/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.ImageStandardExtraction;
import software.amazon.awssdk.services.bedrockdataautomation.model.ImageStandardGenerativeField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageStandardOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageStandardOutputConfiguration> {
    private static final SdkField<ImageStandardExtraction> EXTRACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("extraction").getter(ImageStandardOutputConfiguration.getter(ImageStandardOutputConfiguration::extraction)).setter(ImageStandardOutputConfiguration.setter(Builder::extraction)).constructor(ImageStandardExtraction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()}).build();
    private static final SdkField<ImageStandardGenerativeField> GENERATIVE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generativeField").getter(ImageStandardOutputConfiguration.getter(ImageStandardOutputConfiguration::generativeField)).setter(ImageStandardOutputConfiguration.setter(Builder::generativeField)).constructor(ImageStandardGenerativeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD, GENERATIVE_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageStandardOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ImageStandardExtraction extraction;
    private final ImageStandardGenerativeField generativeField;

    private ImageStandardOutputConfiguration(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.generativeField = builder.generativeField;
    }

    public final ImageStandardExtraction extraction() {
        return this.extraction;
    }

    public final ImageStandardGenerativeField generativeField() {
        return this.generativeField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extraction());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageStandardOutputConfiguration)) {
            return false;
        }
        ImageStandardOutputConfiguration other = (ImageStandardOutputConfiguration)obj;
        return Objects.equals(this.extraction(), other.extraction()) && Objects.equals(this.generativeField(), other.generativeField());
    }

    public final String toString() {
        return ToString.builder((String)"ImageStandardOutputConfiguration").add("Extraction", (Object)this.extraction()).add("GenerativeField", (Object)this.generativeField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extraction": {
                return Optional.ofNullable(clazz.cast(this.extraction()));
            }
            case "generativeField": {
                return Optional.ofNullable(clazz.cast(this.generativeField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("generativeField", GENERATIVE_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageStandardOutputConfiguration, T> g) {
        return obj -> g.apply((ImageStandardOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImageStandardExtraction extraction;
        private ImageStandardGenerativeField generativeField;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageStandardOutputConfiguration model) {
            this.extraction(model.extraction);
            this.generativeField(model.generativeField);
        }

        public final ImageStandardExtraction.Builder getExtraction() {
            return this.extraction != null ? this.extraction.toBuilder() : null;
        }

        public final void setExtraction(ImageStandardExtraction.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(ImageStandardExtraction extraction) {
            this.extraction = extraction;
            return this;
        }

        public final ImageStandardGenerativeField.Builder getGenerativeField() {
            return this.generativeField != null ? this.generativeField.toBuilder() : null;
        }

        public final void setGenerativeField(ImageStandardGenerativeField.BuilderImpl generativeField) {
            this.generativeField = generativeField != null ? generativeField.build() : null;
        }

        @Override
        public final Builder generativeField(ImageStandardGenerativeField generativeField) {
            this.generativeField = generativeField;
            return this;
        }

        public ImageStandardOutputConfiguration build() {
            return new ImageStandardOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageStandardOutputConfiguration> {
        public Builder extraction(ImageStandardExtraction var1);

        default public Builder extraction(Consumer<ImageStandardExtraction.Builder> extraction) {
            return this.extraction((ImageStandardExtraction)((ImageStandardExtraction.Builder)ImageStandardExtraction.builder().applyMutation(extraction)).build());
        }

        public Builder generativeField(ImageStandardGenerativeField var1);

        default public Builder generativeField(Consumer<ImageStandardGenerativeField.Builder> generativeField) {
            return this.generativeField((ImageStandardGenerativeField)((ImageStandardGenerativeField.Builder)ImageStandardGenerativeField.builder().applyMutation(generativeField)).build());
        }
    }
}

