/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.BedrockDataAutomationResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectStage;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataAutomationProjectResponse
extends BedrockDataAutomationResponse
implements ToCopyableBuilder<Builder, CreateDataAutomationProjectResponse> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(CreateDataAutomationProjectResponse.getter(CreateDataAutomationProjectResponse::projectArn)).setter(CreateDataAutomationProjectResponse.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> PROJECT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectStage").getter(CreateDataAutomationProjectResponse.getter(CreateDataAutomationProjectResponse::projectStageAsString)).setter(CreateDataAutomationProjectResponse.setter(Builder::projectStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateDataAutomationProjectResponse.getter(CreateDataAutomationProjectResponse::statusAsString)).setter(CreateDataAutomationProjectResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, PROJECT_STAGE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataAutomationProjectResponse.memberNameToFieldInitializer();
    private final String projectArn;
    private final String projectStage;
    private final String status;

    private CreateDataAutomationProjectResponse(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.projectStage = builder.projectStage;
        this.status = builder.status;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final DataAutomationProjectStage projectStage() {
        return DataAutomationProjectStage.fromValue(this.projectStage);
    }

    public final String projectStageAsString() {
        return this.projectStage;
    }

    public final DataAutomationProjectStatus status() {
        return DataAutomationProjectStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataAutomationProjectResponse)) {
            return false;
        }
        CreateDataAutomationProjectResponse other = (CreateDataAutomationProjectResponse)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.projectStageAsString(), other.projectStageAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataAutomationProjectResponse").add("ProjectArn", (Object)this.projectArn()).add("ProjectStage", (Object)this.projectStageAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "projectStage": {
                return Optional.ofNullable(clazz.cast(this.projectStageAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("projectStage", PROJECT_STAGE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataAutomationProjectResponse, T> g) {
        return obj -> g.apply((CreateDataAutomationProjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationResponse.BuilderImpl
    implements Builder {
        private String projectArn;
        private String projectStage;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataAutomationProjectResponse model) {
            super(model);
            this.projectArn(model.projectArn);
            this.projectStage(model.projectStage);
            this.status(model.status);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectStage() {
            return this.projectStage;
        }

        public final void setProjectStage(String projectStage) {
            this.projectStage = projectStage;
        }

        @Override
        public final Builder projectStage(String projectStage) {
            this.projectStage = projectStage;
            return this;
        }

        @Override
        public final Builder projectStage(DataAutomationProjectStage projectStage) {
            this.projectStage(projectStage == null ? null : projectStage.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataAutomationProjectStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateDataAutomationProjectResponse build() {
            return new CreateDataAutomationProjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockDataAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataAutomationProjectResponse> {
        public Builder projectArn(String var1);

        public Builder projectStage(String var1);

        public Builder projectStage(DataAutomationProjectStage var1);

        public Builder status(String var1);

        public Builder status(DataAutomationProjectStatus var1);
    }
}

