/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.BedrockDataAutomationRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintStageFilter;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectFilter;
import software.amazon.awssdk.services.bedrockdataautomation.model.ResourceOwner;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBlueprintsRequest
extends BedrockDataAutomationRequest
implements ToCopyableBuilder<Builder, ListBlueprintsRequest> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintArn").getter(ListBlueprintsRequest.getter(ListBlueprintsRequest::blueprintArn)).setter(ListBlueprintsRequest.setter(Builder::blueprintArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwner").getter(ListBlueprintsRequest.getter(ListBlueprintsRequest::resourceOwnerAsString)).setter(ListBlueprintsRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()}).build();
    private static final SdkField<String> BLUEPRINT_STAGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintStageFilter").getter(ListBlueprintsRequest.getter(ListBlueprintsRequest::blueprintStageFilterAsString)).setter(ListBlueprintsRequest.setter(Builder::blueprintStageFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStageFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListBlueprintsRequest.getter(ListBlueprintsRequest::maxResults)).setter(ListBlueprintsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBlueprintsRequest.getter(ListBlueprintsRequest::nextToken)).setter(ListBlueprintsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<DataAutomationProjectFilter> PROJECT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("projectFilter").getter(ListBlueprintsRequest.getter(ListBlueprintsRequest::projectFilter)).setter(ListBlueprintsRequest.setter(Builder::projectFilter)).constructor(DataAutomationProjectFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD, RESOURCE_OWNER_FIELD, BLUEPRINT_STAGE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PROJECT_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBlueprintsRequest.memberNameToFieldInitializer();
    private final String blueprintArn;
    private final String resourceOwner;
    private final String blueprintStageFilter;
    private final Integer maxResults;
    private final String nextToken;
    private final DataAutomationProjectFilter projectFilter;

    private ListBlueprintsRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintArn = builder.blueprintArn;
        this.resourceOwner = builder.resourceOwner;
        this.blueprintStageFilter = builder.blueprintStageFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.projectFilter = builder.projectFilter;
    }

    public final String blueprintArn() {
        return this.blueprintArn;
    }

    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(this.resourceOwner);
    }

    public final String resourceOwnerAsString() {
        return this.resourceOwner;
    }

    public final BlueprintStageFilter blueprintStageFilter() {
        return BlueprintStageFilter.fromValue(this.blueprintStageFilter);
    }

    public final String blueprintStageFilterAsString() {
        return this.blueprintStageFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final DataAutomationProjectFilter projectFilter() {
        return this.projectFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintStageFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlueprintsRequest)) {
            return false;
        }
        ListBlueprintsRequest other = (ListBlueprintsRequest)((Object)obj);
        return Objects.equals(this.blueprintArn(), other.blueprintArn()) && Objects.equals(this.resourceOwnerAsString(), other.resourceOwnerAsString()) && Objects.equals(this.blueprintStageFilterAsString(), other.blueprintStageFilterAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.projectFilter(), other.projectFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListBlueprintsRequest").add("BlueprintArn", (Object)this.blueprintArn()).add("ResourceOwner", (Object)this.resourceOwnerAsString()).add("BlueprintStageFilter", (Object)this.blueprintStageFilterAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ProjectFilter", (Object)this.projectFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintArn": {
                return Optional.ofNullable(clazz.cast(this.blueprintArn()));
            }
            case "resourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAsString()));
            }
            case "blueprintStageFilter": {
                return Optional.ofNullable(clazz.cast(this.blueprintStageFilterAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "projectFilter": {
                return Optional.ofNullable(clazz.cast(this.projectFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("resourceOwner", RESOURCE_OWNER_FIELD);
        map.put("blueprintStageFilter", BLUEPRINT_STAGE_FILTER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectFilter", PROJECT_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBlueprintsRequest, T> g) {
        return obj -> g.apply((ListBlueprintsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRequest.BuilderImpl
    implements Builder {
        private String blueprintArn;
        private String resourceOwner;
        private String blueprintStageFilter;
        private Integer maxResults;
        private String nextToken;
        private DataAutomationProjectFilter projectFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlueprintsRequest model) {
            super(model);
            this.blueprintArn(model.blueprintArn);
            this.resourceOwner(model.resourceOwner);
            this.blueprintStageFilter(model.blueprintStageFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.projectFilter(model.projectFilter);
        }

        public final String getBlueprintArn() {
            return this.blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        public final String getBlueprintStageFilter() {
            return this.blueprintStageFilter;
        }

        public final void setBlueprintStageFilter(String blueprintStageFilter) {
            this.blueprintStageFilter = blueprintStageFilter;
        }

        @Override
        public final Builder blueprintStageFilter(String blueprintStageFilter) {
            this.blueprintStageFilter = blueprintStageFilter;
            return this;
        }

        @Override
        public final Builder blueprintStageFilter(BlueprintStageFilter blueprintStageFilter) {
            this.blueprintStageFilter(blueprintStageFilter == null ? null : blueprintStageFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final DataAutomationProjectFilter.Builder getProjectFilter() {
            return this.projectFilter != null ? this.projectFilter.toBuilder() : null;
        }

        public final void setProjectFilter(DataAutomationProjectFilter.BuilderImpl projectFilter) {
            this.projectFilter = projectFilter != null ? projectFilter.build() : null;
        }

        @Override
        public final Builder projectFilter(DataAutomationProjectFilter projectFilter) {
            this.projectFilter = projectFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBlueprintsRequest build() {
            return new ListBlueprintsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockDataAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBlueprintsRequest> {
        public Builder blueprintArn(String var1);

        public Builder resourceOwner(String var1);

        public Builder resourceOwner(ResourceOwner var1);

        public Builder blueprintStageFilter(String var1);

        public Builder blueprintStageFilter(BlueprintStageFilter var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder projectFilter(DataAutomationProjectFilter var1);

        default public Builder projectFilter(Consumer<DataAutomationProjectFilter.Builder> projectFilter) {
            return this.projectFilter((DataAutomationProjectFilter)((DataAutomationProjectFilter.Builder)DataAutomationProjectFilter.builder().applyMutation(projectFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

