/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataAutomationProjectSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataAutomationProjectSummary> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(DataAutomationProjectSummary.getter(DataAutomationProjectSummary::projectArn)).setter(DataAutomationProjectSummary.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> PROJECT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectStage").getter(DataAutomationProjectSummary.getter(DataAutomationProjectSummary::projectStageAsString)).setter(DataAutomationProjectSummary.setter(Builder::projectStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStage").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(DataAutomationProjectSummary.getter(DataAutomationProjectSummary::projectName)).setter(DataAutomationProjectSummary.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DataAutomationProjectSummary.getter(DataAutomationProjectSummary::creationTime)).setter(DataAutomationProjectSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, PROJECT_STAGE_FIELD, PROJECT_NAME_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("projectArn", PROJECT_ARN_FIELD);
            this.put("projectStage", PROJECT_STAGE_FIELD);
            this.put("projectName", PROJECT_NAME_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String projectArn;
    private final String projectStage;
    private final String projectName;
    private final Instant creationTime;

    private DataAutomationProjectSummary(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.projectStage = builder.projectStage;
        this.projectName = builder.projectName;
        this.creationTime = builder.creationTime;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final DataAutomationProjectStage projectStage() {
        return DataAutomationProjectStage.fromValue(this.projectStage);
    }

    public final String projectStageAsString() {
        return this.projectStage;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAutomationProjectSummary)) {
            return false;
        }
        DataAutomationProjectSummary other = (DataAutomationProjectSummary)obj;
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.projectStageAsString(), other.projectStageAsString()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DataAutomationProjectSummary").add("ProjectArn", (Object)this.projectArn()).add("ProjectStage", (Object)this.projectStageAsString()).add("ProjectName", (Object)(this.projectName() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "projectStage": {
                return Optional.ofNullable(clazz.cast(this.projectStageAsString()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataAutomationProjectSummary, T> g) {
        return obj -> g.apply((DataAutomationProjectSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectArn;
        private String projectStage;
        private String projectName;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DataAutomationProjectSummary model) {
            this.projectArn(model.projectArn);
            this.projectStage(model.projectStage);
            this.projectName(model.projectName);
            this.creationTime(model.creationTime);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectStage() {
            return this.projectStage;
        }

        public final void setProjectStage(String projectStage) {
            this.projectStage = projectStage;
        }

        @Override
        public final Builder projectStage(String projectStage) {
            this.projectStage = projectStage;
            return this;
        }

        @Override
        public final Builder projectStage(DataAutomationProjectStage projectStage) {
            this.projectStage(projectStage == null ? null : projectStage.toString());
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public DataAutomationProjectSummary build() {
            return new DataAutomationProjectSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataAutomationProjectSummary> {
        public Builder projectArn(String var1);

        public Builder projectStage(String var1);

        public Builder projectStage(DataAutomationProjectStage var1);

        public Builder projectName(String var1);

        public Builder creationTime(Instant var1);
    }
}

