/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowControlNodeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowTraceNodeInputExecutionChainItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowTraceNodeInputExecutionChainItem> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("index").getter(FlowTraceNodeInputExecutionChainItem.getter(FlowTraceNodeInputExecutionChainItem::index)).setter(FlowTraceNodeInputExecutionChainItem.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(FlowTraceNodeInputExecutionChainItem.getter(FlowTraceNodeInputExecutionChainItem::nodeName)).setter(FlowTraceNodeInputExecutionChainItem.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FlowTraceNodeInputExecutionChainItem.getter(FlowTraceNodeInputExecutionChainItem::typeAsString)).setter(FlowTraceNodeInputExecutionChainItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, NODE_NAME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowTraceNodeInputExecutionChainItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final String nodeName;
    private final String type;

    private FlowTraceNodeInputExecutionChainItem(BuilderImpl builder) {
        this.index = builder.index;
        this.nodeName = builder.nodeName;
        this.type = builder.type;
    }

    public final Integer index() {
        return this.index;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final FlowControlNodeType type() {
        return FlowControlNodeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeInputExecutionChainItem)) {
            return false;
        }
        FlowTraceNodeInputExecutionChainItem other = (FlowTraceNodeInputExecutionChainItem)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlowTraceNodeInputExecutionChainItem").add("Index", (Object)this.index()).add("NodeName", (Object)this.nodeName()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("index", INDEX_FIELD);
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeInputExecutionChainItem, T> g) {
        return obj -> g.apply((FlowTraceNodeInputExecutionChainItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private String nodeName;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeInputExecutionChainItem model) {
            this.index(model.index);
            this.nodeName(model.nodeName);
            this.type(model.type);
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowControlNodeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public FlowTraceNodeInputExecutionChainItem build() {
            return new FlowTraceNodeInputExecutionChainItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowTraceNodeInputExecutionChainItem> {
        public Builder index(Integer var1);

        public Builder nodeName(String var1);

        public Builder type(String var1);

        public Builder type(FlowControlNodeType var1);
    }
}

