/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Identifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Identifier> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketName").getter(S3Identifier.getter(S3Identifier::s3BucketName)).setter(S3Identifier.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()}).build();
    private static final SdkField<String> S3_OBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3ObjectKey").getter(S3Identifier.getter(S3Identifier::s3ObjectKey)).setter(S3Identifier.setter(Builder::s3ObjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ObjectKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, S3_OBJECT_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Identifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final String s3ObjectKey;

    private S3Identifier(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3ObjectKey = builder.s3ObjectKey;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3ObjectKey() {
        return this.s3ObjectKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Identifier)) {
            return false;
        }
        S3Identifier other = (S3Identifier)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3ObjectKey(), other.s3ObjectKey());
    }

    public final String toString() {
        return ToString.builder((String)"S3Identifier").add("S3BucketName", (Object)this.s3BucketName()).add("S3ObjectKey", (Object)this.s3ObjectKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "s3ObjectKey": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("s3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("s3ObjectKey", S3_OBJECT_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Identifier, T> g) {
        return obj -> g.apply((S3Identifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String s3ObjectKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Identifier model) {
            this.s3BucketName(model.s3BucketName);
            this.s3ObjectKey(model.s3ObjectKey);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3ObjectKey() {
            return this.s3ObjectKey;
        }

        public final void setS3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
        }

        @Override
        public final Builder s3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
            return this;
        }

        public S3Identifier build() {
            return new S3Identifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Identifier> {
        public Builder s3BucketName(String var1);

        public Builder s3ObjectKey(String var1);
    }
}

