/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepromptResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepromptResponse> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(RepromptResponse.getter(RepromptResponse::text)).setter(RepromptResponse.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(RepromptResponse.getter(RepromptResponse::sourceAsString)).setter(RepromptResponse.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RepromptResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final String source;

    private RepromptResponse(BuilderImpl builder) {
        this.text = builder.text;
        this.source = builder.source;
    }

    public final String text() {
        return this.text;
    }

    public final Source source() {
        return Source.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepromptResponse)) {
            return false;
        }
        RepromptResponse other = (RepromptResponse)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.sourceAsString(), other.sourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RepromptResponse").add("Text", (Object)this.text()).add("Source", (Object)(this.sourceAsString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("text", TEXT_FIELD);
        map.put("source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepromptResponse, T> g) {
        return obj -> g.apply((RepromptResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(RepromptResponse model) {
            this.text(model.text);
            this.source(model.source);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(Source source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public RepromptResponse build() {
            return new RepromptResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepromptResponse> {
        public Builder text(String var1);

        public Builder source(String var1);

        public Builder source(Source var1);
    }
}

