/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeActionEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeActionEvent> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(NodeActionEvent.getter(NodeActionEvent::nodeName)).setter(NodeActionEvent.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(NodeActionEvent.getter(NodeActionEvent::timestamp)).setter(NodeActionEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(NodeActionEvent.getter(NodeActionEvent::requestId)).setter(NodeActionEvent.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(NodeActionEvent.getter(NodeActionEvent::serviceName)).setter(NodeActionEvent.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationName").getter(NodeActionEvent.getter(NodeActionEvent::operationName)).setter(NodeActionEvent.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()}).build();
    private static final SdkField<Document> OPERATION_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("operationRequest").getter(NodeActionEvent.getter(NodeActionEvent::operationRequest)).setter(NodeActionEvent.setter(Builder::operationRequest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationRequest").build()}).build();
    private static final SdkField<Document> OPERATION_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("operationResponse").getter(NodeActionEvent.getter(NodeActionEvent::operationResponse)).setter(NodeActionEvent.setter(Builder::operationResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD, TIMESTAMP_FIELD, REQUEST_ID_FIELD, SERVICE_NAME_FIELD, OPERATION_NAME_FIELD, OPERATION_REQUEST_FIELD, OPERATION_RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeActionEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeName;
    private final Instant timestamp;
    private final String requestIdValue;
    private final String serviceName;
    private final String operationName;
    private final Document operationRequest;
    private final Document operationResponse;

    private NodeActionEvent(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.timestamp = builder.timestamp;
        this.requestIdValue = builder.requestIdValue;
        this.serviceName = builder.serviceName;
        this.operationName = builder.operationName;
        this.operationRequest = builder.operationRequest;
        this.operationResponse = builder.operationResponse;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final Document operationRequest() {
        return this.operationRequest;
    }

    public final Document operationResponse() {
        return this.operationResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationResponse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeActionEvent)) {
            return false;
        }
        NodeActionEvent other = (NodeActionEvent)obj;
        return Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.operationRequest(), other.operationRequest()) && Objects.equals(this.operationResponse(), other.operationResponse());
    }

    public final String toString() {
        return ToString.builder((String)"NodeActionEvent").add("NodeName", (Object)this.nodeName()).add("Timestamp", (Object)this.timestamp()).add("RequestId", (Object)this.requestId()).add("ServiceName", (Object)this.serviceName()).add("OperationName", (Object)this.operationName()).add("OperationRequest", (Object)this.operationRequest()).add("OperationResponse", (Object)this.operationResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "operationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "operationRequest": {
                return Optional.ofNullable(clazz.cast(this.operationRequest()));
            }
            case "operationResponse": {
                return Optional.ofNullable(clazz.cast(this.operationResponse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("operationName", OPERATION_NAME_FIELD);
        map.put("operationRequest", OPERATION_REQUEST_FIELD);
        map.put("operationResponse", OPERATION_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeActionEvent, T> g) {
        return obj -> g.apply((NodeActionEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeName;
        private Instant timestamp;
        private String requestIdValue;
        private String serviceName;
        private String operationName;
        private Document operationRequest;
        private Document operationResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeActionEvent model) {
            this.nodeName(model.nodeName);
            this.timestamp(model.timestamp);
            this.requestId(model.requestIdValue);
            this.serviceName(model.serviceName);
            this.operationName(model.operationName);
            this.operationRequest(model.operationRequest);
            this.operationResponse(model.operationResponse);
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final Document getOperationRequest() {
            return this.operationRequest;
        }

        public final void setOperationRequest(Document operationRequest) {
            this.operationRequest = operationRequest;
        }

        @Override
        public final Builder operationRequest(Document operationRequest) {
            this.operationRequest = operationRequest;
            return this;
        }

        public final Document getOperationResponse() {
            return this.operationResponse;
        }

        public final void setOperationResponse(Document operationResponse) {
            this.operationResponse = operationResponse;
        }

        @Override
        public final Builder operationResponse(Document operationResponse) {
            this.operationResponse = operationResponse;
            return this;
        }

        public NodeActionEvent build() {
            return new NodeActionEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeActionEvent> {
        public Builder nodeName(String var1);

        public Builder timestamp(Instant var1);

        public Builder requestId(String var1);

        public Builder serviceName(String var1);

        public Builder operationName(String var1);

        public Builder operationRequest(Document var1);

        public Builder operationResponse(Document var1);
    }
}

