/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAction;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailTrace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailTrace> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(GuardrailTrace.getter(GuardrailTrace::actionAsString)).setter(GuardrailTrace.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<List<GuardrailAssessment>> INPUT_ASSESSMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputAssessments").getter(GuardrailTrace.getter(GuardrailTrace::inputAssessments)).setter(GuardrailTrace.setter(Builder::inputAssessments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAssessments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailAssessment>> OUTPUT_ASSESSMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputAssessments").getter(GuardrailTrace.getter(GuardrailTrace::outputAssessments)).setter(GuardrailTrace.setter(Builder::outputAssessments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAssessments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(GuardrailTrace.getter(GuardrailTrace::traceId)).setter(GuardrailTrace.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, INPUT_ASSESSMENTS_FIELD, OUTPUT_ASSESSMENTS_FIELD, TRACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailTrace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final List<GuardrailAssessment> inputAssessments;
    private final List<GuardrailAssessment> outputAssessments;
    private final String traceId;

    private GuardrailTrace(BuilderImpl builder) {
        this.action = builder.action;
        this.inputAssessments = builder.inputAssessments;
        this.outputAssessments = builder.outputAssessments;
        this.traceId = builder.traceId;
    }

    public final GuardrailAction action() {
        return GuardrailAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final boolean hasInputAssessments() {
        return this.inputAssessments != null && !(this.inputAssessments instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAssessment> inputAssessments() {
        return this.inputAssessments;
    }

    public final boolean hasOutputAssessments() {
        return this.outputAssessments != null && !(this.outputAssessments instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAssessment> outputAssessments() {
        return this.outputAssessments;
    }

    public final String traceId() {
        return this.traceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputAssessments() ? this.inputAssessments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputAssessments() ? this.outputAssessments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTrace)) {
            return false;
        }
        GuardrailTrace other = (GuardrailTrace)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasInputAssessments() == other.hasInputAssessments() && Objects.equals(this.inputAssessments(), other.inputAssessments()) && this.hasOutputAssessments() == other.hasOutputAssessments() && Objects.equals(this.outputAssessments(), other.outputAssessments()) && Objects.equals(this.traceId(), other.traceId());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailTrace").add("Action", (Object)this.actionAsString()).add("InputAssessments", (Object)(this.inputAssessments() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputAssessments", (Object)(this.outputAssessments() == null ? null : "*** Sensitive Data Redacted ***")).add("TraceId", (Object)this.traceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "inputAssessments": {
                return Optional.ofNullable(clazz.cast(this.inputAssessments()));
            }
            case "outputAssessments": {
                return Optional.ofNullable(clazz.cast(this.outputAssessments()));
            }
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", ACTION_FIELD);
        map.put("inputAssessments", INPUT_ASSESSMENTS_FIELD);
        map.put("outputAssessments", OUTPUT_ASSESSMENTS_FIELD);
        map.put("traceId", TRACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTrace, T> g) {
        return obj -> g.apply((GuardrailTrace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private List<GuardrailAssessment> inputAssessments = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailAssessment> outputAssessments = DefaultSdkAutoConstructList.getInstance();
        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTrace model) {
            this.action(model.action);
            this.inputAssessments(model.inputAssessments);
            this.outputAssessments(model.outputAssessments);
            this.traceId(model.traceId);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<GuardrailAssessment.Builder> getInputAssessments() {
            List<GuardrailAssessment.Builder> result = GuardrailAssessmentListCopier.copyToBuilder(this.inputAssessments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputAssessments(Collection<GuardrailAssessment.BuilderImpl> inputAssessments) {
            this.inputAssessments = GuardrailAssessmentListCopier.copyFromBuilder(inputAssessments);
        }

        @Override
        public final Builder inputAssessments(Collection<GuardrailAssessment> inputAssessments) {
            this.inputAssessments = GuardrailAssessmentListCopier.copy(inputAssessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAssessments(GuardrailAssessment ... inputAssessments) {
            this.inputAssessments(Arrays.asList(inputAssessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAssessments(Consumer<GuardrailAssessment.Builder> ... inputAssessments) {
            this.inputAssessments(Stream.of(inputAssessments).map(c -> (GuardrailAssessment)((GuardrailAssessment.Builder)GuardrailAssessment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAssessment.Builder> getOutputAssessments() {
            List<GuardrailAssessment.Builder> result = GuardrailAssessmentListCopier.copyToBuilder(this.outputAssessments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputAssessments(Collection<GuardrailAssessment.BuilderImpl> outputAssessments) {
            this.outputAssessments = GuardrailAssessmentListCopier.copyFromBuilder(outputAssessments);
        }

        @Override
        public final Builder outputAssessments(Collection<GuardrailAssessment> outputAssessments) {
            this.outputAssessments = GuardrailAssessmentListCopier.copy(outputAssessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputAssessments(GuardrailAssessment ... outputAssessments) {
            this.outputAssessments(Arrays.asList(outputAssessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputAssessments(Consumer<GuardrailAssessment.Builder> ... outputAssessments) {
            this.outputAssessments(Stream.of(outputAssessments).map(c -> (GuardrailAssessment)((GuardrailAssessment.Builder)GuardrailAssessment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public GuardrailTrace build() {
            return new GuardrailTrace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailTrace> {
        public Builder action(String var1);

        public Builder action(GuardrailAction var1);

        public Builder inputAssessments(Collection<GuardrailAssessment> var1);

        public Builder inputAssessments(GuardrailAssessment ... var1);

        public Builder inputAssessments(Consumer<GuardrailAssessment.Builder> ... var1);

        public Builder outputAssessments(Collection<GuardrailAssessment> var1);

        public Builder outputAssessments(GuardrailAssessment ... var1);

        public Builder outputAssessments(Consumer<GuardrailAssessment.Builder> ... var1);

        public Builder traceId(String var1);
    }
}

