/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionSummary;

public class ListSessionsIterable
implements SdkIterable<ListSessionsResponse> {
    private final BedrockAgentRuntimeClient client;
    private final ListSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSessionsIterable(BedrockAgentRuntimeClient client, ListSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSessionsResponseFetcher();
    }

    public Iterator<ListSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SessionSummary> sessionSummaries() {
        Function<ListSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionSummaries() != null) {
                return response.sessionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSessionsResponseFetcher
    implements SyncPageFetcher<ListSessionsResponse> {
        private ListSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSessionsResponse nextPage(ListSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionsIterable.this.client.listSessions(ListSessionsIterable.this.firstRequest);
            }
            return ListSessionsIterable.this.client.listSessions((ListSessionsRequest)((Object)ListSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

