/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.ExecutionType;
import software.amazon.awssdk.services.bedrockagentruntime.model.Parameter;
import software.amazon.awssdk.services.bedrockagentruntime.model.ParametersCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.RequestBody;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionGroupInvocationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionGroupInvocationInput> {
    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupName").getter(ActionGroupInvocationInput.getter(ActionGroupInvocationInput::actionGroupName)).setter(ActionGroupInvocationInput.setter(Builder::actionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()}).build();
    private static final SdkField<String> API_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiPath").getter(ActionGroupInvocationInput.getter(ActionGroupInvocationInput::apiPath)).setter(ActionGroupInvocationInput.setter(Builder::apiPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiPath").build()}).build();
    private static final SdkField<String> EXECUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionType").getter(ActionGroupInvocationInput.getter(ActionGroupInvocationInput::executionTypeAsString)).setter(ActionGroupInvocationInput.setter(Builder::executionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionType").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("function").getter(ActionGroupInvocationInput.getter(ActionGroupInvocationInput::function)).setter(ActionGroupInvocationInput.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()}).build();
    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationId").getter(ActionGroupInvocationInput.getter(ActionGroupInvocationInput::invocationId)).setter(ActionGroupInvocationInput.setter(Builder::invocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(ActionGroupInvocationInput.getter(ActionGroupInvocationInput::parameters)).setter(ActionGroupInvocationInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RequestBody> REQUEST_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("requestBody").getter(ActionGroupInvocationInput.getter(ActionGroupInvocationInput::requestBody)).setter(ActionGroupInvocationInput.setter(Builder::requestBody)).constructor(RequestBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestBody").build()}).build();
    private static final SdkField<String> VERB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("verb").getter(ActionGroupInvocationInput.getter(ActionGroupInvocationInput::verb)).setter(ActionGroupInvocationInput.setter(Builder::verb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_NAME_FIELD, API_PATH_FIELD, EXECUTION_TYPE_FIELD, FUNCTION_FIELD, INVOCATION_ID_FIELD, PARAMETERS_FIELD, REQUEST_BODY_FIELD, VERB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActionGroupInvocationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionGroupName;
    private final String apiPath;
    private final String executionType;
    private final String function;
    private final String invocationId;
    private final List<Parameter> parameters;
    private final RequestBody requestBody;
    private final String verb;

    private ActionGroupInvocationInput(BuilderImpl builder) {
        this.actionGroupName = builder.actionGroupName;
        this.apiPath = builder.apiPath;
        this.executionType = builder.executionType;
        this.function = builder.function;
        this.invocationId = builder.invocationId;
        this.parameters = builder.parameters;
        this.requestBody = builder.requestBody;
        this.verb = builder.verb;
    }

    public final String actionGroupName() {
        return this.actionGroupName;
    }

    public final String apiPath() {
        return this.apiPath;
    }

    public final ExecutionType executionType() {
        return ExecutionType.fromValue(this.executionType);
    }

    public final String executionTypeAsString() {
        return this.executionType;
    }

    public final String function() {
        return this.function;
    }

    public final String invocationId() {
        return this.invocationId;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> parameters() {
        return this.parameters;
    }

    public final RequestBody requestBody() {
        return this.requestBody;
    }

    public final String verb() {
        return this.verb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.verb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionGroupInvocationInput)) {
            return false;
        }
        ActionGroupInvocationInput other = (ActionGroupInvocationInput)obj;
        return Objects.equals(this.actionGroupName(), other.actionGroupName()) && Objects.equals(this.apiPath(), other.apiPath()) && Objects.equals(this.executionTypeAsString(), other.executionTypeAsString()) && Objects.equals(this.function(), other.function()) && Objects.equals(this.invocationId(), other.invocationId()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.requestBody(), other.requestBody()) && Objects.equals(this.verb(), other.verb());
    }

    public final String toString() {
        return ToString.builder((String)"ActionGroupInvocationInput").add("ActionGroupName", (Object)(this.actionGroupName() == null ? null : "*** Sensitive Data Redacted ***")).add("ApiPath", (Object)(this.apiPath() == null ? null : "*** Sensitive Data Redacted ***")).add("ExecutionType", (Object)this.executionTypeAsString()).add("Function", (Object)(this.function() == null ? null : "*** Sensitive Data Redacted ***")).add("InvocationId", (Object)this.invocationId()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("RequestBody", (Object)this.requestBody()).add("Verb", (Object)(this.verb() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroupName": {
                return Optional.ofNullable(clazz.cast(this.actionGroupName()));
            }
            case "apiPath": {
                return Optional.ofNullable(clazz.cast(this.apiPath()));
            }
            case "executionType": {
                return Optional.ofNullable(clazz.cast(this.executionTypeAsString()));
            }
            case "function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
            case "invocationId": {
                return Optional.ofNullable(clazz.cast(this.invocationId()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "requestBody": {
                return Optional.ofNullable(clazz.cast(this.requestBody()));
            }
            case "verb": {
                return Optional.ofNullable(clazz.cast(this.verb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionGroupName", ACTION_GROUP_NAME_FIELD);
        map.put("apiPath", API_PATH_FIELD);
        map.put("executionType", EXECUTION_TYPE_FIELD);
        map.put("function", FUNCTION_FIELD);
        map.put("invocationId", INVOCATION_ID_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("requestBody", REQUEST_BODY_FIELD);
        map.put("verb", VERB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionGroupInvocationInput, T> g) {
        return obj -> g.apply((ActionGroupInvocationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionGroupName;
        private String apiPath;
        private String executionType;
        private String function;
        private String invocationId;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private RequestBody requestBody;
        private String verb;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionGroupInvocationInput model) {
            this.actionGroupName(model.actionGroupName);
            this.apiPath(model.apiPath);
            this.executionType(model.executionType);
            this.function(model.function);
            this.invocationId(model.invocationId);
            this.parameters(model.parameters);
            this.requestBody(model.requestBody);
            this.verb(model.verb);
        }

        public final String getActionGroupName() {
            return this.actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final String getApiPath() {
            return this.apiPath;
        }

        public final void setApiPath(String apiPath) {
            this.apiPath = apiPath;
        }

        @Override
        public final Builder apiPath(String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        public final String getExecutionType() {
            return this.executionType;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        @Override
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        @Override
        public final Builder executionType(ExecutionType executionType) {
            this.executionType(executionType == null ? null : executionType.toString());
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RequestBody.Builder getRequestBody() {
            return this.requestBody != null ? this.requestBody.toBuilder() : null;
        }

        public final void setRequestBody(RequestBody.BuilderImpl requestBody) {
            this.requestBody = requestBody != null ? requestBody.build() : null;
        }

        @Override
        public final Builder requestBody(RequestBody requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public final String getVerb() {
            return this.verb;
        }

        public final void setVerb(String verb) {
            this.verb = verb;
        }

        @Override
        public final Builder verb(String verb) {
            this.verb = verb;
            return this;
        }

        public ActionGroupInvocationInput build() {
            return new ActionGroupInvocationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionGroupInvocationInput> {
        public Builder actionGroupName(String var1);

        public Builder apiPath(String var1);

        public Builder executionType(String var1);

        public Builder executionType(ExecutionType var1);

        public Builder function(String var1);

        public Builder invocationId(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder requestBody(RequestBody var1);

        default public Builder requestBody(Consumer<RequestBody.Builder> requestBody) {
            return this.requestBody((RequestBody)((RequestBody.Builder)RequestBody.builder().applyMutation(requestBody)).build());
        }

        public Builder verb(String var1);
    }
}

