/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup;
import software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroupsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailConfigurationWithArn;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineBedrockModelConfigurations;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineSessionState;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBasesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeInlineAgentRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeInlineAgentRequest> {
    private static final SdkField<List<AgentActionGroup>> ACTION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionGroups").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::actionGroups)).setter(InvokeInlineAgentRequest.setter(Builder::actionGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentActionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InlineBedrockModelConfigurations> BEDROCK_MODEL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bedrockModelConfigurations").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::bedrockModelConfigurations)).setter(InvokeInlineAgentRequest.setter(Builder::bedrockModelConfigurations)).constructor(InlineBedrockModelConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelConfigurations").build()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::customerEncryptionKeyArn)).setter(InvokeInlineAgentRequest.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableTrace").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::enableTrace)).setter(InvokeInlineAgentRequest.setter(Builder::enableTrace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()}).build();
    private static final SdkField<Boolean> END_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("endSession").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::endSession)).setter(InvokeInlineAgentRequest.setter(Builder::endSession)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endSession").build()}).build();
    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("foundationModel").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::foundationModel)).setter(InvokeInlineAgentRequest.setter(Builder::foundationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()}).build();
    private static final SdkField<GuardrailConfigurationWithArn> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::guardrailConfiguration)).setter(InvokeInlineAgentRequest.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfigurationWithArn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::idleSessionTTLInSeconds)).setter(InvokeInlineAgentRequest.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<InlineSessionState> INLINE_SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inlineSessionState").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::inlineSessionState)).setter(InvokeInlineAgentRequest.setter(Builder::inlineSessionState)).constructor(InlineSessionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineSessionState").build()}).build();
    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputText").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::inputText)).setter(InvokeInlineAgentRequest.setter(Builder::inputText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()}).build();
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instruction").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::instruction)).setter(InvokeInlineAgentRequest.setter(Builder::instruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()}).build();
    private static final SdkField<List<KnowledgeBase>> KNOWLEDGE_BASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("knowledgeBases").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::knowledgeBases)).setter(InvokeInlineAgentRequest.setter(Builder::knowledgeBases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KnowledgeBase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptOverrideConfiguration").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::promptOverrideConfiguration)).setter(InvokeInlineAgentRequest.setter(Builder::promptOverrideConfiguration)).constructor(PromptOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(InvokeInlineAgentRequest.getter(InvokeInlineAgentRequest::sessionId)).setter(InvokeInlineAgentRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUPS_FIELD, BEDROCK_MODEL_CONFIGURATIONS_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, ENABLE_TRACE_FIELD, END_SESSION_FIELD, FOUNDATION_MODEL_FIELD, GUARDRAIL_CONFIGURATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, INLINE_SESSION_STATE_FIELD, INPUT_TEXT_FIELD, INSTRUCTION_FIELD, KNOWLEDGE_BASES_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeInlineAgentRequest.memberNameToFieldInitializer();
    private final List<AgentActionGroup> actionGroups;
    private final InlineBedrockModelConfigurations bedrockModelConfigurations;
    private final String customerEncryptionKeyArn;
    private final Boolean enableTrace;
    private final Boolean endSession;
    private final String foundationModel;
    private final GuardrailConfigurationWithArn guardrailConfiguration;
    private final Integer idleSessionTTLInSeconds;
    private final InlineSessionState inlineSessionState;
    private final String inputText;
    private final String instruction;
    private final List<KnowledgeBase> knowledgeBases;
    private final PromptOverrideConfiguration promptOverrideConfiguration;
    private final String sessionId;

    private InvokeInlineAgentRequest(BuilderImpl builder) {
        super(builder);
        this.actionGroups = builder.actionGroups;
        this.bedrockModelConfigurations = builder.bedrockModelConfigurations;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.enableTrace = builder.enableTrace;
        this.endSession = builder.endSession;
        this.foundationModel = builder.foundationModel;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.inlineSessionState = builder.inlineSessionState;
        this.inputText = builder.inputText;
        this.instruction = builder.instruction;
        this.knowledgeBases = builder.knowledgeBases;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
        this.sessionId = builder.sessionId;
    }

    public final boolean hasActionGroups() {
        return this.actionGroups != null && !(this.actionGroups instanceof SdkAutoConstructList);
    }

    public final List<AgentActionGroup> actionGroups() {
        return this.actionGroups;
    }

    public final InlineBedrockModelConfigurations bedrockModelConfigurations() {
        return this.bedrockModelConfigurations;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final Boolean enableTrace() {
        return this.enableTrace;
    }

    public final Boolean endSession() {
        return this.endSession;
    }

    public final String foundationModel() {
        return this.foundationModel;
    }

    public final GuardrailConfigurationWithArn guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final InlineSessionState inlineSessionState() {
        return this.inlineSessionState;
    }

    public final String inputText() {
        return this.inputText;
    }

    public final String instruction() {
        return this.instruction;
    }

    public final boolean hasKnowledgeBases() {
        return this.knowledgeBases != null && !(this.knowledgeBases instanceof SdkAutoConstructList);
    }

    public final List<KnowledgeBase> knowledgeBases() {
        return this.knowledgeBases;
    }

    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return this.promptOverrideConfiguration;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionGroups() ? this.actionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bedrockModelConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.endSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineSessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputText());
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKnowledgeBases() ? this.knowledgeBases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.promptOverrideConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeInlineAgentRequest)) {
            return false;
        }
        InvokeInlineAgentRequest other = (InvokeInlineAgentRequest)((Object)obj);
        return this.hasActionGroups() == other.hasActionGroups() && Objects.equals(this.actionGroups(), other.actionGroups()) && Objects.equals(this.bedrockModelConfigurations(), other.bedrockModelConfigurations()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.enableTrace(), other.enableTrace()) && Objects.equals(this.endSession(), other.endSession()) && Objects.equals(this.foundationModel(), other.foundationModel()) && Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.inlineSessionState(), other.inlineSessionState()) && Objects.equals(this.inputText(), other.inputText()) && Objects.equals(this.instruction(), other.instruction()) && this.hasKnowledgeBases() == other.hasKnowledgeBases() && Objects.equals(this.knowledgeBases(), other.knowledgeBases()) && Objects.equals(this.promptOverrideConfiguration(), other.promptOverrideConfiguration()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeInlineAgentRequest").add("ActionGroups", this.hasActionGroups() ? this.actionGroups() : null).add("BedrockModelConfigurations", (Object)this.bedrockModelConfigurations()).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("EnableTrace", (Object)this.enableTrace()).add("EndSession", (Object)this.endSession()).add("FoundationModel", (Object)this.foundationModel()).add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("InlineSessionState", (Object)this.inlineSessionState()).add("InputText", (Object)(this.inputText() == null ? null : "*** Sensitive Data Redacted ***")).add("Instruction", (Object)(this.instruction() == null ? null : "*** Sensitive Data Redacted ***")).add("KnowledgeBases", this.hasKnowledgeBases() ? this.knowledgeBases() : null).add("PromptOverrideConfiguration", (Object)(this.promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroups": {
                return Optional.ofNullable(clazz.cast(this.actionGroups()));
            }
            case "bedrockModelConfigurations": {
                return Optional.ofNullable(clazz.cast(this.bedrockModelConfigurations()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "enableTrace": {
                return Optional.ofNullable(clazz.cast(this.enableTrace()));
            }
            case "endSession": {
                return Optional.ofNullable(clazz.cast(this.endSession()));
            }
            case "foundationModel": {
                return Optional.ofNullable(clazz.cast(this.foundationModel()));
            }
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "inlineSessionState": {
                return Optional.ofNullable(clazz.cast(this.inlineSessionState()));
            }
            case "inputText": {
                return Optional.ofNullable(clazz.cast(this.inputText()));
            }
            case "instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "knowledgeBases": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBases()));
            }
            case "promptOverrideConfiguration": {
                return Optional.ofNullable(clazz.cast(this.promptOverrideConfiguration()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionGroups", ACTION_GROUPS_FIELD);
        map.put("bedrockModelConfigurations", BEDROCK_MODEL_CONFIGURATIONS_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        map.put("endSession", END_SESSION_FIELD);
        map.put("foundationModel", FOUNDATION_MODEL_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("inlineSessionState", INLINE_SESSION_STATE_FIELD);
        map.put("inputText", INPUT_TEXT_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("knowledgeBases", KNOWLEDGE_BASES_FIELD);
        map.put("promptOverrideConfiguration", PROMPT_OVERRIDE_CONFIGURATION_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeInlineAgentRequest, T> g) {
        return obj -> g.apply((InvokeInlineAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private List<AgentActionGroup> actionGroups = DefaultSdkAutoConstructList.getInstance();
        private InlineBedrockModelConfigurations bedrockModelConfigurations;
        private String customerEncryptionKeyArn;
        private Boolean enableTrace;
        private Boolean endSession;
        private String foundationModel;
        private GuardrailConfigurationWithArn guardrailConfiguration;
        private Integer idleSessionTTLInSeconds;
        private InlineSessionState inlineSessionState;
        private String inputText;
        private String instruction;
        private List<KnowledgeBase> knowledgeBases = DefaultSdkAutoConstructList.getInstance();
        private PromptOverrideConfiguration promptOverrideConfiguration;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeInlineAgentRequest model) {
            super(model);
            this.actionGroups(model.actionGroups);
            this.bedrockModelConfigurations(model.bedrockModelConfigurations);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.enableTrace(model.enableTrace);
            this.endSession(model.endSession);
            this.foundationModel(model.foundationModel);
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.inlineSessionState(model.inlineSessionState);
            this.inputText(model.inputText);
            this.instruction(model.instruction);
            this.knowledgeBases(model.knowledgeBases);
            this.promptOverrideConfiguration(model.promptOverrideConfiguration);
            this.sessionId(model.sessionId);
        }

        public final List<AgentActionGroup.Builder> getActionGroups() {
            List<AgentActionGroup.Builder> result = AgentActionGroupsCopier.copyToBuilder(this.actionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionGroups(Collection<AgentActionGroup.BuilderImpl> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copyFromBuilder(actionGroups);
        }

        @Override
        public final Builder actionGroups(Collection<AgentActionGroup> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copy(actionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(AgentActionGroup ... actionGroups) {
            this.actionGroups(Arrays.asList(actionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(Consumer<AgentActionGroup.Builder> ... actionGroups) {
            this.actionGroups(Stream.of(actionGroups).map(c -> (AgentActionGroup)((AgentActionGroup.Builder)AgentActionGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InlineBedrockModelConfigurations.Builder getBedrockModelConfigurations() {
            return this.bedrockModelConfigurations != null ? this.bedrockModelConfigurations.toBuilder() : null;
        }

        public final void setBedrockModelConfigurations(InlineBedrockModelConfigurations.BuilderImpl bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations != null ? bedrockModelConfigurations.build() : null;
        }

        @Override
        public final Builder bedrockModelConfigurations(InlineBedrockModelConfigurations bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final Boolean getEnableTrace() {
            return this.enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final Boolean getEndSession() {
            return this.endSession;
        }

        public final void setEndSession(Boolean endSession) {
            this.endSession = endSession;
        }

        @Override
        public final Builder endSession(Boolean endSession) {
            this.endSession = endSession;
            return this;
        }

        public final String getFoundationModel() {
            return this.foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final GuardrailConfigurationWithArn.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfigurationWithArn.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfigurationWithArn guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final InlineSessionState.Builder getInlineSessionState() {
            return this.inlineSessionState != null ? this.inlineSessionState.toBuilder() : null;
        }

        public final void setInlineSessionState(InlineSessionState.BuilderImpl inlineSessionState) {
            this.inlineSessionState = inlineSessionState != null ? inlineSessionState.build() : null;
        }

        @Override
        public final Builder inlineSessionState(InlineSessionState inlineSessionState) {
            this.inlineSessionState = inlineSessionState;
            return this;
        }

        public final String getInputText() {
            return this.inputText;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public final String getInstruction() {
            return this.instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final List<KnowledgeBase.Builder> getKnowledgeBases() {
            List<KnowledgeBase.Builder> result = KnowledgeBasesCopier.copyToBuilder(this.knowledgeBases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKnowledgeBases(Collection<KnowledgeBase.BuilderImpl> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copyFromBuilder(knowledgeBases);
        }

        @Override
        public final Builder knowledgeBases(Collection<KnowledgeBase> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copy(knowledgeBases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(KnowledgeBase ... knowledgeBases) {
            this.knowledgeBases(Arrays.asList(knowledgeBases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(Consumer<KnowledgeBase.Builder> ... knowledgeBases) {
            this.knowledgeBases(Stream.of(knowledgeBases).map(c -> (KnowledgeBase)((KnowledgeBase.Builder)KnowledgeBase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return this.promptOverrideConfiguration != null ? this.promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeInlineAgentRequest build() {
            return new InvokeInlineAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeInlineAgentRequest> {
        public Builder actionGroups(Collection<AgentActionGroup> var1);

        public Builder actionGroups(AgentActionGroup ... var1);

        public Builder actionGroups(Consumer<AgentActionGroup.Builder> ... var1);

        public Builder bedrockModelConfigurations(InlineBedrockModelConfigurations var1);

        default public Builder bedrockModelConfigurations(Consumer<InlineBedrockModelConfigurations.Builder> bedrockModelConfigurations) {
            return this.bedrockModelConfigurations((InlineBedrockModelConfigurations)((InlineBedrockModelConfigurations.Builder)InlineBedrockModelConfigurations.builder().applyMutation(bedrockModelConfigurations)).build());
        }

        public Builder customerEncryptionKeyArn(String var1);

        public Builder enableTrace(Boolean var1);

        public Builder endSession(Boolean var1);

        public Builder foundationModel(String var1);

        public Builder guardrailConfiguration(GuardrailConfigurationWithArn var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfigurationWithArn.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfigurationWithArn)((GuardrailConfigurationWithArn.Builder)GuardrailConfigurationWithArn.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder inlineSessionState(InlineSessionState var1);

        default public Builder inlineSessionState(Consumer<InlineSessionState.Builder> inlineSessionState) {
            return this.inlineSessionState((InlineSessionState)((InlineSessionState.Builder)InlineSessionState.builder().applyMutation(inlineSessionState)).build());
        }

        public Builder inputText(String var1);

        public Builder instruction(String var1);

        public Builder knowledgeBases(Collection<KnowledgeBase> var1);

        public Builder knowledgeBases(KnowledgeBase ... var1);

        public Builder knowledgeBases(Consumer<KnowledgeBase.Builder> ... var1);

        public Builder promptOverrideConfiguration(PromptOverrideConfiguration var1);

        default public Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return this.promptOverrideConfiguration((PromptOverrideConfiguration)((PromptOverrideConfiguration.Builder)PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)).build());
        }

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

