/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information pertaining to the action group or knowledge base that is being invoked.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvocationInput implements SdkPojo, Serializable, ToCopyableBuilder<InvocationInput.Builder, InvocationInput> {
    private static final SdkField<ActionGroupInvocationInput> ACTION_GROUP_INVOCATION_INPUT_FIELD = SdkField
            .<ActionGroupInvocationInput> builder(MarshallingType.SDK_POJO)
            .memberName("actionGroupInvocationInput")
            .getter(getter(InvocationInput::actionGroupInvocationInput))
            .setter(setter(Builder::actionGroupInvocationInput))
            .constructor(ActionGroupInvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupInvocationInput").build())
            .build();

    private static final SdkField<CodeInterpreterInvocationInput> CODE_INTERPRETER_INVOCATION_INPUT_FIELD = SdkField
            .<CodeInterpreterInvocationInput> builder(MarshallingType.SDK_POJO)
            .memberName("codeInterpreterInvocationInput")
            .getter(getter(InvocationInput::codeInterpreterInvocationInput))
            .setter(setter(Builder::codeInterpreterInvocationInput))
            .constructor(CodeInterpreterInvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterInvocationInput")
                    .build()).build();

    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationType").getter(getter(InvocationInput::invocationTypeAsString))
            .setter(setter(Builder::invocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationType").build()).build();

    private static final SdkField<KnowledgeBaseLookupInput> KNOWLEDGE_BASE_LOOKUP_INPUT_FIELD = SdkField
            .<KnowledgeBaseLookupInput> builder(MarshallingType.SDK_POJO).memberName("knowledgeBaseLookupInput")
            .getter(getter(InvocationInput::knowledgeBaseLookupInput)).setter(setter(Builder::knowledgeBaseLookupInput))
            .constructor(KnowledgeBaseLookupInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseLookupInput").build())
            .build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(InvocationInput::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTION_GROUP_INVOCATION_INPUT_FIELD, CODE_INTERPRETER_INVOCATION_INPUT_FIELD, INVOCATION_TYPE_FIELD,
            KNOWLEDGE_BASE_LOOKUP_INPUT_FIELD, TRACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActionGroupInvocationInput actionGroupInvocationInput;

    private final CodeInterpreterInvocationInput codeInterpreterInvocationInput;

    private final String invocationType;

    private final KnowledgeBaseLookupInput knowledgeBaseLookupInput;

    private final String traceId;

    private InvocationInput(BuilderImpl builder) {
        this.actionGroupInvocationInput = builder.actionGroupInvocationInput;
        this.codeInterpreterInvocationInput = builder.codeInterpreterInvocationInput;
        this.invocationType = builder.invocationType;
        this.knowledgeBaseLookupInput = builder.knowledgeBaseLookupInput;
        this.traceId = builder.traceId;
    }

    /**
     * <p>
     * Contains information about the action group to be invoked.
     * </p>
     * 
     * @return Contains information about the action group to be invoked.
     */
    public final ActionGroupInvocationInput actionGroupInvocationInput() {
        return actionGroupInvocationInput;
    }

    /**
     * <p>
     * Contains information about the code interpreter to be invoked.
     * </p>
     * 
     * @return Contains information about the code interpreter to be invoked.
     */
    public final CodeInterpreterInvocationInput codeInterpreterInvocationInput() {
        return codeInterpreterInvocationInput;
    }

    /**
     * <p>
     * Specifies whether the agent is invoking an action group or a knowledge base.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link InvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the agent is invoking an action group or a knowledge base.
     * @see InvocationType
     */
    public final InvocationType invocationType() {
        return InvocationType.fromValue(invocationType);
    }

    /**
     * <p>
     * Specifies whether the agent is invoking an action group or a knowledge base.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link InvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the agent is invoking an action group or a knowledge base.
     * @see InvocationType
     */
    public final String invocationTypeAsString() {
        return invocationType;
    }

    /**
     * <p>
     * Contains details about the knowledge base to look up and the query to be made.
     * </p>
     * 
     * @return Contains details about the knowledge base to look up and the query to be made.
     */
    public final KnowledgeBaseLookupInput knowledgeBaseLookupInput() {
        return knowledgeBaseLookupInput;
    }

    /**
     * <p>
     * The unique identifier of the trace.
     * </p>
     * 
     * @return The unique identifier of the trace.
     */
    public final String traceId() {
        return traceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(invocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseLookupInput());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationInput)) {
            return false;
        }
        InvocationInput other = (InvocationInput) obj;
        return Objects.equals(actionGroupInvocationInput(), other.actionGroupInvocationInput())
                && Objects.equals(codeInterpreterInvocationInput(), other.codeInterpreterInvocationInput())
                && Objects.equals(invocationTypeAsString(), other.invocationTypeAsString())
                && Objects.equals(knowledgeBaseLookupInput(), other.knowledgeBaseLookupInput())
                && Objects.equals(traceId(), other.traceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvocationInput").add("ActionGroupInvocationInput", actionGroupInvocationInput())
                .add("CodeInterpreterInvocationInput", codeInterpreterInvocationInput())
                .add("InvocationType", invocationTypeAsString()).add("KnowledgeBaseLookupInput", knowledgeBaseLookupInput())
                .add("TraceId", traceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroupInvocationInput":
            return Optional.ofNullable(clazz.cast(actionGroupInvocationInput()));
        case "codeInterpreterInvocationInput":
            return Optional.ofNullable(clazz.cast(codeInterpreterInvocationInput()));
        case "invocationType":
            return Optional.ofNullable(clazz.cast(invocationTypeAsString()));
        case "knowledgeBaseLookupInput":
            return Optional.ofNullable(clazz.cast(knowledgeBaseLookupInput()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvocationInput, T> g) {
        return obj -> g.apply((InvocationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvocationInput> {
        /**
         * <p>
         * Contains information about the action group to be invoked.
         * </p>
         * 
         * @param actionGroupInvocationInput
         *        Contains information about the action group to be invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupInvocationInput(ActionGroupInvocationInput actionGroupInvocationInput);

        /**
         * <p>
         * Contains information about the action group to be invoked.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionGroupInvocationInput.Builder}
         * avoiding the need to create one manually via {@link ActionGroupInvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionGroupInvocationInput.Builder#build()} is called immediately
         * and its result is passed to {@link #actionGroupInvocationInput(ActionGroupInvocationInput)}.
         * 
         * @param actionGroupInvocationInput
         *        a consumer that will call methods on {@link ActionGroupInvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroupInvocationInput(ActionGroupInvocationInput)
         */
        default Builder actionGroupInvocationInput(Consumer<ActionGroupInvocationInput.Builder> actionGroupInvocationInput) {
            return actionGroupInvocationInput(ActionGroupInvocationInput.builder().applyMutation(actionGroupInvocationInput)
                    .build());
        }

        /**
         * <p>
         * Contains information about the code interpreter to be invoked.
         * </p>
         * 
         * @param codeInterpreterInvocationInput
         *        Contains information about the code interpreter to be invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterInvocationInput(CodeInterpreterInvocationInput codeInterpreterInvocationInput);

        /**
         * <p>
         * Contains information about the code interpreter to be invoked.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeInterpreterInvocationInput.Builder}
         * avoiding the need to create one manually via {@link CodeInterpreterInvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeInterpreterInvocationInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #codeInterpreterInvocationInput(CodeInterpreterInvocationInput)}.
         * 
         * @param codeInterpreterInvocationInput
         *        a consumer that will call methods on {@link CodeInterpreterInvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeInterpreterInvocationInput(CodeInterpreterInvocationInput)
         */
        default Builder codeInterpreterInvocationInput(
                Consumer<CodeInterpreterInvocationInput.Builder> codeInterpreterInvocationInput) {
            return codeInterpreterInvocationInput(CodeInterpreterInvocationInput.builder()
                    .applyMutation(codeInterpreterInvocationInput).build());
        }

        /**
         * <p>
         * Specifies whether the agent is invoking an action group or a knowledge base.
         * </p>
         * 
         * @param invocationType
         *        Specifies whether the agent is invoking an action group or a knowledge base.
         * @see InvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(String invocationType);

        /**
         * <p>
         * Specifies whether the agent is invoking an action group or a knowledge base.
         * </p>
         * 
         * @param invocationType
         *        Specifies whether the agent is invoking an action group or a knowledge base.
         * @see InvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(InvocationType invocationType);

        /**
         * <p>
         * Contains details about the knowledge base to look up and the query to be made.
         * </p>
         * 
         * @param knowledgeBaseLookupInput
         *        Contains details about the knowledge base to look up and the query to be made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseLookupInput(KnowledgeBaseLookupInput knowledgeBaseLookupInput);

        /**
         * <p>
         * Contains details about the knowledge base to look up and the query to be made.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseLookupInput.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBaseLookupInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseLookupInput.Builder#build()} is called immediately
         * and its result is passed to {@link #knowledgeBaseLookupInput(KnowledgeBaseLookupInput)}.
         * 
         * @param knowledgeBaseLookupInput
         *        a consumer that will call methods on {@link KnowledgeBaseLookupInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseLookupInput(KnowledgeBaseLookupInput)
         */
        default Builder knowledgeBaseLookupInput(Consumer<KnowledgeBaseLookupInput.Builder> knowledgeBaseLookupInput) {
            return knowledgeBaseLookupInput(KnowledgeBaseLookupInput.builder().applyMutation(knowledgeBaseLookupInput).build());
        }

        /**
         * <p>
         * The unique identifier of the trace.
         * </p>
         * 
         * @param traceId
         *        The unique identifier of the trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);
    }

    static final class BuilderImpl implements Builder {
        private ActionGroupInvocationInput actionGroupInvocationInput;

        private CodeInterpreterInvocationInput codeInterpreterInvocationInput;

        private String invocationType;

        private KnowledgeBaseLookupInput knowledgeBaseLookupInput;

        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationInput model) {
            actionGroupInvocationInput(model.actionGroupInvocationInput);
            codeInterpreterInvocationInput(model.codeInterpreterInvocationInput);
            invocationType(model.invocationType);
            knowledgeBaseLookupInput(model.knowledgeBaseLookupInput);
            traceId(model.traceId);
        }

        public final ActionGroupInvocationInput.Builder getActionGroupInvocationInput() {
            return actionGroupInvocationInput != null ? actionGroupInvocationInput.toBuilder() : null;
        }

        public final void setActionGroupInvocationInput(ActionGroupInvocationInput.BuilderImpl actionGroupInvocationInput) {
            this.actionGroupInvocationInput = actionGroupInvocationInput != null ? actionGroupInvocationInput.build() : null;
        }

        @Override
        public final Builder actionGroupInvocationInput(ActionGroupInvocationInput actionGroupInvocationInput) {
            this.actionGroupInvocationInput = actionGroupInvocationInput;
            return this;
        }

        public final CodeInterpreterInvocationInput.Builder getCodeInterpreterInvocationInput() {
            return codeInterpreterInvocationInput != null ? codeInterpreterInvocationInput.toBuilder() : null;
        }

        public final void setCodeInterpreterInvocationInput(
                CodeInterpreterInvocationInput.BuilderImpl codeInterpreterInvocationInput) {
            this.codeInterpreterInvocationInput = codeInterpreterInvocationInput != null ? codeInterpreterInvocationInput.build()
                    : null;
        }

        @Override
        public final Builder codeInterpreterInvocationInput(CodeInterpreterInvocationInput codeInterpreterInvocationInput) {
            this.codeInterpreterInvocationInput = codeInterpreterInvocationInput;
            return this;
        }

        public final String getInvocationType() {
            return invocationType;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        public final KnowledgeBaseLookupInput.Builder getKnowledgeBaseLookupInput() {
            return knowledgeBaseLookupInput != null ? knowledgeBaseLookupInput.toBuilder() : null;
        }

        public final void setKnowledgeBaseLookupInput(KnowledgeBaseLookupInput.BuilderImpl knowledgeBaseLookupInput) {
            this.knowledgeBaseLookupInput = knowledgeBaseLookupInput != null ? knowledgeBaseLookupInput.build() : null;
        }

        @Override
        public final Builder knowledgeBaseLookupInput(KnowledgeBaseLookupInput knowledgeBaseLookupInput) {
            this.knowledgeBaseLookupInput = knowledgeBaseLookupInput;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public InvocationInput build() {
            return new InvocationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
