/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationInputMember;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationInputsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.ResponseStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReturnControlPayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReturnControlPayload>,
ResponseStream {
    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationId").getter(ReturnControlPayload.getter(ReturnControlPayload::invocationId)).setter(ReturnControlPayload.setter(Builder::invocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()}).build();
    private static final SdkField<List<InvocationInputMember>> INVOCATION_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invocationInputs").getter(ReturnControlPayload.getter(ReturnControlPayload::invocationInputs)).setter(ReturnControlPayload.setter(Builder::invocationInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationInputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvocationInputMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_ID_FIELD, INVOCATION_INPUTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String invocationId;
    private final List<InvocationInputMember> invocationInputs;

    protected ReturnControlPayload(BuilderImpl builder) {
        this.invocationId = builder.invocationId;
        this.invocationInputs = builder.invocationInputs;
    }

    public final String invocationId() {
        return this.invocationId;
    }

    public final boolean hasInvocationInputs() {
        return this.invocationInputs != null && !(this.invocationInputs instanceof SdkAutoConstructList);
    }

    public final List<InvocationInputMember> invocationInputs() {
        return this.invocationInputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvocationInputs() ? this.invocationInputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReturnControlPayload)) {
            return false;
        }
        ReturnControlPayload other = (ReturnControlPayload)obj;
        return Objects.equals(this.invocationId(), other.invocationId()) && this.hasInvocationInputs() == other.hasInvocationInputs() && Objects.equals(this.invocationInputs(), other.invocationInputs());
    }

    public final String toString() {
        return ToString.builder((String)"ReturnControlPayload").add("InvocationId", (Object)this.invocationId()).add("InvocationInputs", this.hasInvocationInputs() ? this.invocationInputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invocationId": {
                return Optional.ofNullable(clazz.cast(this.invocationId()));
            }
            case "invocationInputs": {
                return Optional.ofNullable(clazz.cast(this.invocationInputs()));
            }
        }
        return Optional.empty();
    }

    public final ReturnControlPayload copy(Consumer<? super Builder> modifier) {
        return (ReturnControlPayload)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReturnControlPayload, T> g) {
        return obj -> g.apply((ReturnControlPayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(InvokeAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String invocationId;
        private List<InvocationInputMember> invocationInputs = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(ReturnControlPayload model) {
            this.invocationId(model.invocationId);
            this.invocationInputs(model.invocationInputs);
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final List<InvocationInputMember.Builder> getInvocationInputs() {
            List<InvocationInputMember.Builder> result = InvocationInputsCopier.copyToBuilder(this.invocationInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvocationInputs(Collection<InvocationInputMember.BuilderImpl> invocationInputs) {
            this.invocationInputs = InvocationInputsCopier.copyFromBuilder(invocationInputs);
        }

        @Override
        public final Builder invocationInputs(Collection<InvocationInputMember> invocationInputs) {
            this.invocationInputs = InvocationInputsCopier.copy(invocationInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationInputs(InvocationInputMember ... invocationInputs) {
            this.invocationInputs(Arrays.asList(invocationInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationInputs(Consumer<InvocationInputMember.Builder> ... invocationInputs) {
            this.invocationInputs(Stream.of(invocationInputs).map(c -> (InvocationInputMember)((InvocationInputMember.Builder)InvocationInputMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReturnControlPayload build() {
            return new ReturnControlPayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReturnControlPayload> {
        public Builder invocationId(String var1);

        public Builder invocationInputs(Collection<InvocationInputMember> var1);

        public Builder invocationInputs(InvocationInputMember ... var1);

        public Builder invocationInputs(Consumer<InvocationInputMember.Builder> ... var1);
    }
}

