/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trace Part which contains intermidate response for customer
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TracePart implements SdkPojo, Serializable, ToCopyableBuilder<TracePart.Builder, TracePart>, ResponseStream {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(TracePart::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasId").getter(getter(TracePart::agentAliasId)).setter(setter(Builder::agentAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(TracePart::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Trace> TRACE_FIELD = SdkField.<Trace> builder(MarshallingType.SDK_POJO).memberName("trace")
            .getter(getter(TracePart::trace)).setter(setter(Builder::trace)).constructor(Trace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_ALIAS_ID_FIELD, SESSION_ID_FIELD, TRACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String agentAliasId;

    private final String sessionId;

    private final Trace trace;

    protected TracePart(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentAliasId = builder.agentAliasId;
        this.sessionId = builder.sessionId;
        this.trace = builder.trace;
    }

    /**
     * Returns the value of the AgentId property for this object.
     * 
     * @return The value of the AgentId property for this object.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * Returns the value of the AgentAliasId property for this object.
     * 
     * @return The value of the AgentAliasId property for this object.
     */
    public final String agentAliasId() {
        return agentAliasId;
    }

    /**
     * Returns the value of the SessionId property for this object.
     * 
     * @return The value of the SessionId property for this object.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * Returns the value of the Trace property for this object.
     * 
     * @return The value of the Trace property for this object.
     */
    public final Trace trace() {
        return trace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(trace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TracePart)) {
            return false;
        }
        TracePart other = (TracePart) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentAliasId(), other.agentAliasId())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(trace(), other.trace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TracePart").add("AgentId", agentId()).add("AgentAliasId", agentAliasId())
                .add("SessionId", sessionId()).add("Trace", trace() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentAliasId":
            return Optional.ofNullable(clazz.cast(agentAliasId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "trace":
            return Optional.ofNullable(clazz.cast(trace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final TracePart copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TracePart, T> g) {
        return obj -> g.apply((TracePart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link TracePart}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TracePart> {
        /**
         * Sets the value of the AgentId property for this object.
         *
         * @param agentId
         *        The new value for the AgentId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * Sets the value of the AgentAliasId property for this object.
         *
         * @param agentAliasId
         *        The new value for the AgentAliasId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasId(String agentAliasId);

        /**
         * Sets the value of the SessionId property for this object.
         *
         * @param sessionId
         *        The new value for the SessionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * Sets the value of the Trace property for this object.
         *
         * @param trace
         *        The new value for the Trace property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trace(Trace trace);

        /**
         * Sets the value of the Trace property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Trace.Builder} avoiding the need to
         * create one manually via {@link Trace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Trace.Builder#build()} is called immediately and its result is
         * passed to {@link #trace(Trace)}.
         * 
         * @param trace
         *        a consumer that will call methods on {@link Trace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trace(Trace)
         */
        default Builder trace(Consumer<Trace.Builder> trace) {
            return trace(Trace.builder().applyMutation(trace).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private String agentId;

        private String agentAliasId;

        private String sessionId;

        private Trace trace;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TracePart model) {
            agentId(model.agentId);
            agentAliasId(model.agentAliasId);
            sessionId(model.sessionId);
            trace(model.trace);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentAliasId() {
            return agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Trace.Builder getTrace() {
            return trace != null ? trace.toBuilder() : null;
        }

        public final void setTrace(Trace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(Trace trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public TracePart build() {
            return new TracePart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
