/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source location of a retrieval result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalResultLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalResultLocation.Builder, RetrievalResultLocation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RetrievalResultLocation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<RetrievalResultS3Location> S3_LOCATION_FIELD = SdkField
            .<RetrievalResultS3Location> builder(MarshallingType.SDK_POJO).memberName("s3Location")
            .getter(getter(RetrievalResultLocation::s3Location)).setter(setter(Builder::s3Location))
            .constructor(RetrievalResultS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TYPE_FIELD, S3_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final RetrievalResultS3Location s3Location;

    private RetrievalResultLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Location = builder.s3Location;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see RetrievalResultLocationType
     */
    public final RetrievalResultLocationType type() {
        return RetrievalResultLocationType.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see RetrievalResultLocationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the S3Location property for this object.
     * 
     * @return The value of the S3Location property for this object.
     */
    public final RetrievalResultS3Location s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalResultLocation)) {
            return false;
        }
        RetrievalResultLocation other = (RetrievalResultLocation) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(s3Location(), other.s3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalResultLocation").add("Type", typeAsString()).add("S3Location", s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrievalResultLocation, T> g) {
        return obj -> g.apply((RetrievalResultLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalResultLocation> {
        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see RetrievalResultLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultLocationType
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see RetrievalResultLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultLocationType
         */
        Builder type(RetrievalResultLocationType type);

        /**
         * Sets the value of the S3Location property for this object.
         *
         * @param s3Location
         *        The new value for the S3Location property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(RetrievalResultS3Location s3Location);

        /**
         * Sets the value of the S3Location property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetrievalResultS3Location.Builder}
         * avoiding the need to create one manually via {@link RetrievalResultS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultS3Location.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Location(RetrievalResultS3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link RetrievalResultS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(RetrievalResultS3Location)
         */
        default Builder s3Location(Consumer<RetrievalResultS3Location.Builder> s3Location) {
            return s3Location(RetrievalResultS3Location.builder().applyMutation(s3Location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private RetrievalResultS3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalResultLocation model) {
            type(model.type);
            s3Location(model.s3Location);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrievalResultLocationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final RetrievalResultS3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(RetrievalResultS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(RetrievalResultS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        @Override
        public RetrievalResultLocation build() {
            return new RetrievalResultLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
