/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetPolicyEngineRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetPolicyEngineResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetPolicyGenerationRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetPolicyGenerationResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetPolicyRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetPolicyResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.waiters.BedrockAgentCoreControlWaiter;
import software.amazon.awssdk.services.bedrockagentcorecontrol.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultBedrockAgentCoreControlWaiter
implements BedrockAgentCoreControlWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final BedrockAgentCoreControlClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetMemoryResponse> memoryCreatedWaiter;
    private final Waiter<GetPolicyResponse> policyActiveWaiter;
    private final Waiter<GetPolicyResponse> policyDeletedWaiter;
    private final Waiter<GetPolicyEngineResponse> policyEngineActiveWaiter;
    private final Waiter<GetPolicyEngineResponse> policyEngineDeletedWaiter;
    private final Waiter<GetPolicyGenerationResponse> policyGenerationCompletedWaiter;

    private DefaultBedrockAgentCoreControlWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (BedrockAgentCoreControlClient)BedrockAgentCoreControlClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.memoryCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetMemoryResponse.class).acceptors(DefaultBedrockAgentCoreControlWaiter.memoryCreatedWaiterAcceptors())).overrideConfiguration(DefaultBedrockAgentCoreControlWaiter.memoryCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.policyActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPolicyResponse.class).acceptors(DefaultBedrockAgentCoreControlWaiter.policyActiveWaiterAcceptors())).overrideConfiguration(DefaultBedrockAgentCoreControlWaiter.policyActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.policyDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPolicyResponse.class).acceptors(DefaultBedrockAgentCoreControlWaiter.policyDeletedWaiterAcceptors())).overrideConfiguration(DefaultBedrockAgentCoreControlWaiter.policyDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.policyEngineActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPolicyEngineResponse.class).acceptors(DefaultBedrockAgentCoreControlWaiter.policyEngineActiveWaiterAcceptors())).overrideConfiguration(DefaultBedrockAgentCoreControlWaiter.policyEngineActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.policyEngineDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPolicyEngineResponse.class).acceptors(DefaultBedrockAgentCoreControlWaiter.policyEngineDeletedWaiterAcceptors())).overrideConfiguration(DefaultBedrockAgentCoreControlWaiter.policyEngineDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.policyGenerationCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPolicyGenerationResponse.class).acceptors(DefaultBedrockAgentCoreControlWaiter.policyGenerationCompletedWaiterAcceptors())).overrideConfiguration(DefaultBedrockAgentCoreControlWaiter.policyGenerationCompletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetMemoryResponse> waitUntilMemoryCreated(GetMemoryRequest getMemoryRequest) {
        return this.memoryCreatedWaiter.run(() -> this.client.getMemory(this.applyWaitersUserAgent(getMemoryRequest)));
    }

    @Override
    public WaiterResponse<GetMemoryResponse> waitUntilMemoryCreated(GetMemoryRequest getMemoryRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.memoryCreatedWaiter.run(() -> this.client.getMemory(this.applyWaitersUserAgent(getMemoryRequest)), DefaultBedrockAgentCoreControlWaiter.memoryCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPolicyResponse> waitUntilPolicyActive(GetPolicyRequest getPolicyRequest) {
        return this.policyActiveWaiter.run(() -> this.client.getPolicy(this.applyWaitersUserAgent(getPolicyRequest)));
    }

    @Override
    public WaiterResponse<GetPolicyResponse> waitUntilPolicyActive(GetPolicyRequest getPolicyRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.policyActiveWaiter.run(() -> this.client.getPolicy(this.applyWaitersUserAgent(getPolicyRequest)), DefaultBedrockAgentCoreControlWaiter.policyActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPolicyResponse> waitUntilPolicyDeleted(GetPolicyRequest getPolicyRequest) {
        return this.policyDeletedWaiter.run(() -> this.client.getPolicy(this.applyWaitersUserAgent(getPolicyRequest)));
    }

    @Override
    public WaiterResponse<GetPolicyResponse> waitUntilPolicyDeleted(GetPolicyRequest getPolicyRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.policyDeletedWaiter.run(() -> this.client.getPolicy(this.applyWaitersUserAgent(getPolicyRequest)), DefaultBedrockAgentCoreControlWaiter.policyDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPolicyEngineResponse> waitUntilPolicyEngineActive(GetPolicyEngineRequest getPolicyEngineRequest) {
        return this.policyEngineActiveWaiter.run(() -> this.client.getPolicyEngine(this.applyWaitersUserAgent(getPolicyEngineRequest)));
    }

    @Override
    public WaiterResponse<GetPolicyEngineResponse> waitUntilPolicyEngineActive(GetPolicyEngineRequest getPolicyEngineRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.policyEngineActiveWaiter.run(() -> this.client.getPolicyEngine(this.applyWaitersUserAgent(getPolicyEngineRequest)), DefaultBedrockAgentCoreControlWaiter.policyEngineActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPolicyEngineResponse> waitUntilPolicyEngineDeleted(GetPolicyEngineRequest getPolicyEngineRequest) {
        return this.policyEngineDeletedWaiter.run(() -> this.client.getPolicyEngine(this.applyWaitersUserAgent(getPolicyEngineRequest)));
    }

    @Override
    public WaiterResponse<GetPolicyEngineResponse> waitUntilPolicyEngineDeleted(GetPolicyEngineRequest getPolicyEngineRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.policyEngineDeletedWaiter.run(() -> this.client.getPolicyEngine(this.applyWaitersUserAgent(getPolicyEngineRequest)), DefaultBedrockAgentCoreControlWaiter.policyEngineDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPolicyGenerationResponse> waitUntilPolicyGenerationCompleted(GetPolicyGenerationRequest getPolicyGenerationRequest) {
        return this.policyGenerationCompletedWaiter.run(() -> this.client.getPolicyGeneration(this.applyWaitersUserAgent(getPolicyGenerationRequest)));
    }

    @Override
    public WaiterResponse<GetPolicyGenerationResponse> waitUntilPolicyGenerationCompleted(GetPolicyGenerationRequest getPolicyGenerationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.policyGenerationCompletedWaiter.run(() -> this.client.getPolicyGeneration(this.applyWaitersUserAgent(getPolicyGenerationRequest)), DefaultBedrockAgentCoreControlWaiter.policyGenerationCompletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetMemoryResponse>> memoryCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetMemoryResponse>> result = new ArrayList<WaiterAcceptor<? super GetMemoryResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("memory").field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("memory").field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("memory").field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (memory.status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPolicyResponse>> policyActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPolicyResponse>> result = new ArrayList<WaiterAcceptor<? super GetPolicyResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPolicyResponse>> policyDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPolicyResponse>> result = new ArrayList<WaiterAcceptor<? super GetPolicyResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultBedrockAgentCoreControlWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPolicyEngineResponse>> policyEngineActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPolicyEngineResponse>> result = new ArrayList<WaiterAcceptor<? super GetPolicyEngineResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPolicyEngineResponse>> policyEngineDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPolicyEngineResponse>> result = new ArrayList<WaiterAcceptor<? super GetPolicyEngineResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultBedrockAgentCoreControlWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPolicyGenerationResponse>> policyGenerationCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPolicyGenerationResponse>> result = new ArrayList<WaiterAcceptor<? super GetPolicyGenerationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "GENERATED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "GENERATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "GENERATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=GENERATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration memoryCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration policyActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration policyDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration policyEngineActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration policyEngineDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration policyGenerationCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static BedrockAgentCoreControlWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends BedrockAgentCoreControlRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((BedrockAgentCoreControlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements BedrockAgentCoreControlWaiter.Builder {
        private BedrockAgentCoreControlClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public BedrockAgentCoreControlWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public BedrockAgentCoreControlWaiter.Builder client(BedrockAgentCoreControlClient client) {
            this.client = client;
            return this;
        }

        @Override
        public BedrockAgentCoreControlWaiter build() {
            return new DefaultBedrockAgentCoreControlWaiter(this);
        }
    }
}

