/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.McpSupportedVersionsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SearchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MCPGatewayConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MCPGatewayConfiguration> {
    private static final SdkField<List<String>> SUPPORTED_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedVersions").getter(MCPGatewayConfiguration.getter(MCPGatewayConfiguration::supportedVersions)).setter(MCPGatewayConfiguration.setter(Builder::supportedVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instructions").getter(MCPGatewayConfiguration.getter(MCPGatewayConfiguration::instructions)).setter(MCPGatewayConfiguration.setter(Builder::instructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructions").build()}).build();
    private static final SdkField<String> SEARCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchType").getter(MCPGatewayConfiguration.getter(MCPGatewayConfiguration::searchTypeAsString)).setter(MCPGatewayConfiguration.setter(Builder::searchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_VERSIONS_FIELD, INSTRUCTIONS_FIELD, SEARCH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MCPGatewayConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> supportedVersions;
    private final String instructions;
    private final String searchType;

    private MCPGatewayConfiguration(BuilderImpl builder) {
        this.supportedVersions = builder.supportedVersions;
        this.instructions = builder.instructions;
        this.searchType = builder.searchType;
    }

    public final boolean hasSupportedVersions() {
        return this.supportedVersions != null && !(this.supportedVersions instanceof SdkAutoConstructList);
    }

    public final List<String> supportedVersions() {
        return this.supportedVersions;
    }

    public final String instructions() {
        return this.instructions;
    }

    public final SearchType searchType() {
        return SearchType.fromValue(this.searchType);
    }

    public final String searchTypeAsString() {
        return this.searchType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedVersions() ? this.supportedVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MCPGatewayConfiguration)) {
            return false;
        }
        MCPGatewayConfiguration other = (MCPGatewayConfiguration)obj;
        return this.hasSupportedVersions() == other.hasSupportedVersions() && Objects.equals(this.supportedVersions(), other.supportedVersions()) && Objects.equals(this.instructions(), other.instructions()) && Objects.equals(this.searchTypeAsString(), other.searchTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MCPGatewayConfiguration").add("SupportedVersions", this.hasSupportedVersions() ? this.supportedVersions() : null).add("Instructions", (Object)this.instructions()).add("SearchType", (Object)this.searchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "supportedVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedVersions()));
            }
            case "instructions": {
                return Optional.ofNullable(clazz.cast(this.instructions()));
            }
            case "searchType": {
                return Optional.ofNullable(clazz.cast(this.searchTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supportedVersions", SUPPORTED_VERSIONS_FIELD);
        map.put("instructions", INSTRUCTIONS_FIELD);
        map.put("searchType", SEARCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MCPGatewayConfiguration, T> g) {
        return obj -> g.apply((MCPGatewayConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedVersions = DefaultSdkAutoConstructList.getInstance();
        private String instructions;
        private String searchType;

        private BuilderImpl() {
        }

        private BuilderImpl(MCPGatewayConfiguration model) {
            this.supportedVersions(model.supportedVersions);
            this.instructions(model.instructions);
            this.searchType(model.searchType);
        }

        public final Collection<String> getSupportedVersions() {
            if (this.supportedVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedVersions;
        }

        public final void setSupportedVersions(Collection<String> supportedVersions) {
            this.supportedVersions = McpSupportedVersionsCopier.copy(supportedVersions);
        }

        @Override
        public final Builder supportedVersions(Collection<String> supportedVersions) {
            this.supportedVersions = McpSupportedVersionsCopier.copy(supportedVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedVersions(String ... supportedVersions) {
            this.supportedVersions(Arrays.asList(supportedVersions));
            return this;
        }

        public final String getInstructions() {
            return this.instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public final String getSearchType() {
            return this.searchType;
        }

        public final void setSearchType(String searchType) {
            this.searchType = searchType;
        }

        @Override
        public final Builder searchType(String searchType) {
            this.searchType = searchType;
            return this;
        }

        @Override
        public final Builder searchType(SearchType searchType) {
            this.searchType(searchType == null ? null : searchType.toString());
            return this;
        }

        public MCPGatewayConfiguration build() {
            return new MCPGatewayConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MCPGatewayConfiguration> {
        public Builder supportedVersions(Collection<String> var1);

        public Builder supportedVersions(String ... var1);

        public Builder instructions(String var1);

        public Builder searchType(String var1);

        public Builder searchType(SearchType var1);
    }
}

