/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.InferenceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BedrockEvaluatorModelConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BedrockEvaluatorModelConfig> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(BedrockEvaluatorModelConfig.getter(BedrockEvaluatorModelConfig::modelId)).setter(BedrockEvaluatorModelConfig.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfig").getter(BedrockEvaluatorModelConfig.getter(BedrockEvaluatorModelConfig::inferenceConfig)).setter(BedrockEvaluatorModelConfig.setter(Builder::inferenceConfig)).constructor(InferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()}).build();
    private static final SdkField<Document> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("additionalModelRequestFields").getter(BedrockEvaluatorModelConfig.getter(BedrockEvaluatorModelConfig::additionalModelRequestFields)).setter(BedrockEvaluatorModelConfig.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, INFERENCE_CONFIG_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BedrockEvaluatorModelConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelId;
    private final InferenceConfiguration inferenceConfig;
    private final Document additionalModelRequestFields;

    private BedrockEvaluatorModelConfig(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.inferenceConfig = builder.inferenceConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final InferenceConfiguration inferenceConfig() {
        return this.inferenceConfig;
    }

    public final Document additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalModelRequestFields());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockEvaluatorModelConfig)) {
            return false;
        }
        BedrockEvaluatorModelConfig other = (BedrockEvaluatorModelConfig)obj;
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields());
    }

    public final String toString() {
        return ToString.builder((String)"BedrockEvaluatorModelConfig").add("ModelId", (Object)this.modelId()).add("InferenceConfig", (Object)this.inferenceConfig()).add("AdditionalModelRequestFields", (Object)this.additionalModelRequestFields()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "inferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockEvaluatorModelConfig, T> g) {
        return obj -> g.apply((BedrockEvaluatorModelConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelId;
        private InferenceConfiguration inferenceConfig;
        private Document additionalModelRequestFields;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockEvaluatorModelConfig model) {
            this.modelId(model.modelId);
            this.inferenceConfig(model.inferenceConfig);
            this.additionalModelRequestFields(model.additionalModelRequestFields);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final InferenceConfiguration.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(InferenceConfiguration.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(InferenceConfiguration inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final Document getAdditionalModelRequestFields() {
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
        }

        @Override
        public final Builder additionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
            return this;
        }

        public BedrockEvaluatorModelConfig build() {
            return new BedrockEvaluatorModelConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BedrockEvaluatorModelConfig> {
        public Builder modelId(String var1);

        public Builder inferenceConfig(InferenceConfiguration var1);

        default public Builder inferenceConfig(Consumer<InferenceConfiguration.Builder> inferenceConfig) {
            return this.inferenceConfig((InferenceConfiguration)((InferenceConfiguration.Builder)InferenceConfiguration.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder additionalModelRequestFields(Document var1);
    }
}

