/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Filter;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.FilterListCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SamplingConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SessionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<SamplingConfig> SAMPLING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("samplingConfig").getter(Rule.getter(Rule::samplingConfig)).setter(Rule.setter(Builder::samplingConfig)).constructor(SamplingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingConfig").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(Rule.getter(Rule::filters)).setter(Rule.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SessionConfig> SESSION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionConfig").getter(Rule.getter(Rule::sessionConfig)).setter(Rule.setter(Builder::sessionConfig)).constructor(SessionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_CONFIG_FIELD, FILTERS_FIELD, SESSION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Rule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SamplingConfig samplingConfig;
    private final List<Filter> filters;
    private final SessionConfig sessionConfig;

    private Rule(BuilderImpl builder) {
        this.samplingConfig = builder.samplingConfig;
        this.filters = builder.filters;
        this.sessionConfig = builder.sessionConfig;
    }

    public final SamplingConfig samplingConfig() {
        return this.samplingConfig;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final SessionConfig sessionConfig() {
        return this.sessionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.samplingConfig(), other.samplingConfig()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.sessionConfig(), other.sessionConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("SamplingConfig", (Object)this.samplingConfig()).add("Filters", this.hasFilters() ? this.filters() : null).add("SessionConfig", (Object)this.sessionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "samplingConfig": {
                return Optional.ofNullable(clazz.cast(this.samplingConfig()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "sessionConfig": {
                return Optional.ofNullable(clazz.cast(this.sessionConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("samplingConfig", SAMPLING_CONFIG_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("sessionConfig", SESSION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SamplingConfig samplingConfig;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private SessionConfig sessionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.samplingConfig(model.samplingConfig);
            this.filters(model.filters);
            this.sessionConfig(model.sessionConfig);
        }

        public final SamplingConfig.Builder getSamplingConfig() {
            return this.samplingConfig != null ? this.samplingConfig.toBuilder() : null;
        }

        public final void setSamplingConfig(SamplingConfig.BuilderImpl samplingConfig) {
            this.samplingConfig = samplingConfig != null ? samplingConfig.build() : null;
        }

        @Override
        public final Builder samplingConfig(SamplingConfig samplingConfig) {
            this.samplingConfig = samplingConfig;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SessionConfig.Builder getSessionConfig() {
            return this.sessionConfig != null ? this.sessionConfig.toBuilder() : null;
        }

        public final void setSessionConfig(SessionConfig.BuilderImpl sessionConfig) {
            this.sessionConfig = sessionConfig != null ? sessionConfig.build() : null;
        }

        @Override
        public final Builder sessionConfig(SessionConfig sessionConfig) {
            this.sessionConfig = sessionConfig;
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder samplingConfig(SamplingConfig var1);

        default public Builder samplingConfig(Consumer<SamplingConfig.Builder> samplingConfig) {
            return this.samplingConfig((SamplingConfig)((SamplingConfig.Builder)SamplingConfig.builder().applyMutation(samplingConfig)).build());
        }

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder sessionConfig(SessionConfig var1);

        default public Builder sessionConfig(Consumer<SessionConfig.Builder> sessionConfig) {
            return this.sessionConfig((SessionConfig)((SessionConfig.Builder)SessionConfig.builder().applyMutation(sessionConfig)).build());
        }
    }
}

