/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyDefinition;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyValidationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePolicyRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, UpdatePolicyRequest> {
    private static final SdkField<String> POLICY_ENGINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyEngineId").getter(UpdatePolicyRequest.getter(UpdatePolicyRequest::policyEngineId)).setter(UpdatePolicyRequest.setter(Builder::policyEngineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyEngineId").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyId").getter(UpdatePolicyRequest.getter(UpdatePolicyRequest::policyId)).setter(UpdatePolicyRequest.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdatePolicyRequest.getter(UpdatePolicyRequest::description)).setter(UpdatePolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<PolicyDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(UpdatePolicyRequest.getter(UpdatePolicyRequest::definition)).setter(UpdatePolicyRequest.setter(Builder::definition)).constructor(PolicyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> VALIDATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationMode").getter(UpdatePolicyRequest.getter(UpdatePolicyRequest::validationModeAsString)).setter(UpdatePolicyRequest.setter(Builder::validationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ENGINE_ID_FIELD, POLICY_ID_FIELD, DESCRIPTION_FIELD, DEFINITION_FIELD, VALIDATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePolicyRequest.memberNameToFieldInitializer();
    private final String policyEngineId;
    private final String policyId;
    private final String description;
    private final PolicyDefinition definition;
    private final String validationMode;

    private UpdatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyEngineId = builder.policyEngineId;
        this.policyId = builder.policyId;
        this.description = builder.description;
        this.definition = builder.definition;
        this.validationMode = builder.validationMode;
    }

    public final String policyEngineId() {
        return this.policyEngineId;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String description() {
        return this.description;
    }

    public final PolicyDefinition definition() {
        return this.definition;
    }

    public final PolicyValidationMode validationMode() {
        return PolicyValidationMode.fromValue(this.validationMode);
    }

    public final String validationModeAsString() {
        return this.validationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyEngineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicyRequest)) {
            return false;
        }
        UpdatePolicyRequest other = (UpdatePolicyRequest)((Object)obj);
        return Objects.equals(this.policyEngineId(), other.policyEngineId()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.validationModeAsString(), other.validationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePolicyRequest").add("PolicyEngineId", (Object)this.policyEngineId()).add("PolicyId", (Object)this.policyId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Definition", (Object)this.definition()).add("ValidationMode", (Object)this.validationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyEngineId": {
                return Optional.ofNullable(clazz.cast(this.policyEngineId()));
            }
            case "policyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "validationMode": {
                return Optional.ofNullable(clazz.cast(this.validationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyEngineId", POLICY_ENGINE_ID_FIELD);
        map.put("policyId", POLICY_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("validationMode", VALIDATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePolicyRequest, T> g) {
        return obj -> g.apply((UpdatePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String policyEngineId;
        private String policyId;
        private String description;
        private PolicyDefinition definition;
        private String validationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicyRequest model) {
            super(model);
            this.policyEngineId(model.policyEngineId);
            this.policyId(model.policyId);
            this.description(model.description);
            this.definition(model.definition);
            this.validationMode(model.validationMode);
        }

        public final String getPolicyEngineId() {
            return this.policyEngineId;
        }

        public final void setPolicyEngineId(String policyEngineId) {
            this.policyEngineId = policyEngineId;
        }

        @Override
        public final Builder policyEngineId(String policyEngineId) {
            this.policyEngineId = policyEngineId;
            return this;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PolicyDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(PolicyDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PolicyDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getValidationMode() {
            return this.validationMode;
        }

        public final void setValidationMode(String validationMode) {
            this.validationMode = validationMode;
        }

        @Override
        public final Builder validationMode(String validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        @Override
        public final Builder validationMode(PolicyValidationMode validationMode) {
            this.validationMode(validationMode == null ? null : validationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePolicyRequest build() {
            return new UpdatePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePolicyRequest> {
        public Builder policyEngineId(String var1);

        public Builder policyId(String var1);

        public Builder description(String var1);

        public Builder definition(PolicyDefinition var1);

        default public Builder definition(Consumer<PolicyDefinition.Builder> definition) {
            return this.definition((PolicyDefinition)((PolicyDefinition.Builder)PolicyDefinition.builder().applyMutation(definition)).build());
        }

        public Builder validationMode(String var1);

        public Builder validationMode(PolicyValidationMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

