/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ConsolidationConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ExtractionConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OverrideType;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ReflectionConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SelfManagedConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StrategyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StrategyConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(StrategyConfiguration.getter(StrategyConfiguration::typeAsString)).setter(StrategyConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<ExtractionConfiguration> EXTRACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("extraction").getter(StrategyConfiguration.getter(StrategyConfiguration::extraction)).setter(StrategyConfiguration.setter(Builder::extraction)).constructor(ExtractionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()}).build();
    private static final SdkField<ConsolidationConfiguration> CONSOLIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("consolidation").getter(StrategyConfiguration.getter(StrategyConfiguration::consolidation)).setter(StrategyConfiguration.setter(Builder::consolidation)).constructor(ConsolidationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consolidation").build()}).build();
    private static final SdkField<ReflectionConfiguration> REFLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reflection").getter(StrategyConfiguration.getter(StrategyConfiguration::reflection)).setter(StrategyConfiguration.setter(Builder::reflection)).constructor(ReflectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reflection").build()}).build();
    private static final SdkField<SelfManagedConfiguration> SELF_MANAGED_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("selfManagedConfiguration").getter(StrategyConfiguration.getter(StrategyConfiguration::selfManagedConfiguration)).setter(StrategyConfiguration.setter(Builder::selfManagedConfiguration)).constructor(SelfManagedConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfManagedConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EXTRACTION_FIELD, CONSOLIDATION_FIELD, REFLECTION_FIELD, SELF_MANAGED_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StrategyConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final ExtractionConfiguration extraction;
    private final ConsolidationConfiguration consolidation;
    private final ReflectionConfiguration reflection;
    private final SelfManagedConfiguration selfManagedConfiguration;

    private StrategyConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.extraction = builder.extraction;
        this.consolidation = builder.consolidation;
        this.reflection = builder.reflection;
        this.selfManagedConfiguration = builder.selfManagedConfiguration;
    }

    public final OverrideType type() {
        return OverrideType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ExtractionConfiguration extraction() {
        return this.extraction;
    }

    public final ConsolidationConfiguration consolidation() {
        return this.consolidation;
    }

    public final ReflectionConfiguration reflection() {
        return this.reflection;
    }

    public final SelfManagedConfiguration selfManagedConfiguration() {
        return this.selfManagedConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraction());
        hashCode = 31 * hashCode + Objects.hashCode(this.consolidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.reflection());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrategyConfiguration)) {
            return false;
        }
        StrategyConfiguration other = (StrategyConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.extraction(), other.extraction()) && Objects.equals(this.consolidation(), other.consolidation()) && Objects.equals(this.reflection(), other.reflection()) && Objects.equals(this.selfManagedConfiguration(), other.selfManagedConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StrategyConfiguration").add("Type", (Object)this.typeAsString()).add("Extraction", (Object)this.extraction()).add("Consolidation", (Object)this.consolidation()).add("Reflection", (Object)this.reflection()).add("SelfManagedConfiguration", (Object)this.selfManagedConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "extraction": {
                return Optional.ofNullable(clazz.cast(this.extraction()));
            }
            case "consolidation": {
                return Optional.ofNullable(clazz.cast(this.consolidation()));
            }
            case "reflection": {
                return Optional.ofNullable(clazz.cast(this.reflection()));
            }
            case "selfManagedConfiguration": {
                return Optional.ofNullable(clazz.cast(this.selfManagedConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("extraction", EXTRACTION_FIELD);
        map.put("consolidation", CONSOLIDATION_FIELD);
        map.put("reflection", REFLECTION_FIELD);
        map.put("selfManagedConfiguration", SELF_MANAGED_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StrategyConfiguration, T> g) {
        return obj -> g.apply((StrategyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private ExtractionConfiguration extraction;
        private ConsolidationConfiguration consolidation;
        private ReflectionConfiguration reflection;
        private SelfManagedConfiguration selfManagedConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StrategyConfiguration model) {
            this.type(model.type);
            this.extraction(model.extraction);
            this.consolidation(model.consolidation);
            this.reflection(model.reflection);
            this.selfManagedConfiguration(model.selfManagedConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OverrideType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ExtractionConfiguration.Builder getExtraction() {
            return this.extraction != null ? this.extraction.toBuilder() : null;
        }

        public final void setExtraction(ExtractionConfiguration.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(ExtractionConfiguration extraction) {
            this.extraction = extraction;
            return this;
        }

        public final ConsolidationConfiguration.Builder getConsolidation() {
            return this.consolidation != null ? this.consolidation.toBuilder() : null;
        }

        public final void setConsolidation(ConsolidationConfiguration.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(ConsolidationConfiguration consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        public final ReflectionConfiguration.Builder getReflection() {
            return this.reflection != null ? this.reflection.toBuilder() : null;
        }

        public final void setReflection(ReflectionConfiguration.BuilderImpl reflection) {
            this.reflection = reflection != null ? reflection.build() : null;
        }

        @Override
        public final Builder reflection(ReflectionConfiguration reflection) {
            this.reflection = reflection;
            return this;
        }

        public final SelfManagedConfiguration.Builder getSelfManagedConfiguration() {
            return this.selfManagedConfiguration != null ? this.selfManagedConfiguration.toBuilder() : null;
        }

        public final void setSelfManagedConfiguration(SelfManagedConfiguration.BuilderImpl selfManagedConfiguration) {
            this.selfManagedConfiguration = selfManagedConfiguration != null ? selfManagedConfiguration.build() : null;
        }

        @Override
        public final Builder selfManagedConfiguration(SelfManagedConfiguration selfManagedConfiguration) {
            this.selfManagedConfiguration = selfManagedConfiguration;
            return this;
        }

        public StrategyConfiguration build() {
            return new StrategyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StrategyConfiguration> {
        public Builder type(String var1);

        public Builder type(OverrideType var1);

        public Builder extraction(ExtractionConfiguration var1);

        default public Builder extraction(Consumer<ExtractionConfiguration.Builder> extraction) {
            return this.extraction((ExtractionConfiguration)((ExtractionConfiguration.Builder)ExtractionConfiguration.builder().applyMutation(extraction)).build());
        }

        public Builder consolidation(ConsolidationConfiguration var1);

        default public Builder consolidation(Consumer<ConsolidationConfiguration.Builder> consolidation) {
            return this.consolidation((ConsolidationConfiguration)((ConsolidationConfiguration.Builder)ConsolidationConfiguration.builder().applyMutation(consolidation)).build());
        }

        public Builder reflection(ReflectionConfiguration var1);

        default public Builder reflection(Consumer<ReflectionConfiguration.Builder> reflection) {
            return this.reflection((ReflectionConfiguration)((ReflectionConfiguration.Builder)ReflectionConfiguration.builder().applyMutation(reflection)).build());
        }

        public Builder selfManagedConfiguration(SelfManagedConfiguration var1);

        default public Builder selfManagedConfiguration(Consumer<SelfManagedConfiguration.Builder> selfManagedConfiguration) {
            return this.selfManagedConfiguration((SelfManagedConfiguration)((SelfManagedConfiguration.Builder)SelfManagedConfiguration.builder().applyMutation(selfManagedConfiguration)).build());
        }
    }
}

