/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApiKeyCredentialLocation {
    HEADER("HEADER"),
    QUERY_PARAMETER("QUERY_PARAMETER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApiKeyCredentialLocation> VALUE_MAP;
    private final String value;

    private ApiKeyCredentialLocation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApiKeyCredentialLocation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApiKeyCredentialLocation> knownValues() {
        EnumSet<ApiKeyCredentialLocation> knownValues = EnumSet.allOf(ApiKeyCredentialLocation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApiKeyCredentialLocation.class, ApiKeyCredentialLocation::toString);
    }
}

