/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Finding;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.FindingsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyGenerationAsset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyGenerationAsset> {
    private static final SdkField<String> POLICY_GENERATION_ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyGenerationAssetId").getter(PolicyGenerationAsset.getter(PolicyGenerationAsset::policyGenerationAssetId)).setter(PolicyGenerationAsset.setter(Builder::policyGenerationAssetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyGenerationAssetId").build()}).build();
    private static final SdkField<PolicyDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(PolicyGenerationAsset.getter(PolicyGenerationAsset::definition)).setter(PolicyGenerationAsset.setter(Builder::definition)).constructor(PolicyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> RAW_TEXT_FRAGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rawTextFragment").getter(PolicyGenerationAsset.getter(PolicyGenerationAsset::rawTextFragment)).setter(PolicyGenerationAsset.setter(Builder::rawTextFragment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawTextFragment").build()}).build();
    private static final SdkField<List<Finding>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findings").getter(PolicyGenerationAsset.getter(PolicyGenerationAsset::findings)).setter(PolicyGenerationAsset.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Finding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_GENERATION_ASSET_ID_FIELD, DEFINITION_FIELD, RAW_TEXT_FRAGMENT_FIELD, FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyGenerationAsset.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyGenerationAssetId;
    private final PolicyDefinition definition;
    private final String rawTextFragment;
    private final List<Finding> findings;

    private PolicyGenerationAsset(BuilderImpl builder) {
        this.policyGenerationAssetId = builder.policyGenerationAssetId;
        this.definition = builder.definition;
        this.rawTextFragment = builder.rawTextFragment;
        this.findings = builder.findings;
    }

    public final String policyGenerationAssetId() {
        return this.policyGenerationAssetId;
    }

    public final PolicyDefinition definition() {
        return this.definition;
    }

    public final String rawTextFragment() {
        return this.rawTextFragment;
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<Finding> findings() {
        return this.findings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyGenerationAssetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawTextFragment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGenerationAsset)) {
            return false;
        }
        PolicyGenerationAsset other = (PolicyGenerationAsset)obj;
        return Objects.equals(this.policyGenerationAssetId(), other.policyGenerationAssetId()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.rawTextFragment(), other.rawTextFragment()) && this.hasFindings() == other.hasFindings() && Objects.equals(this.findings(), other.findings());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyGenerationAsset").add("PolicyGenerationAssetId", (Object)this.policyGenerationAssetId()).add("Definition", (Object)this.definition()).add("RawTextFragment", (Object)this.rawTextFragment()).add("Findings", this.hasFindings() ? this.findings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyGenerationAssetId": {
                return Optional.ofNullable(clazz.cast(this.policyGenerationAssetId()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "rawTextFragment": {
                return Optional.ofNullable(clazz.cast(this.rawTextFragment()));
            }
            case "findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyGenerationAssetId", POLICY_GENERATION_ASSET_ID_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("rawTextFragment", RAW_TEXT_FRAGMENT_FIELD);
        map.put("findings", FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyGenerationAsset, T> g) {
        return obj -> g.apply((PolicyGenerationAsset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyGenerationAssetId;
        private PolicyDefinition definition;
        private String rawTextFragment;
        private List<Finding> findings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGenerationAsset model) {
            this.policyGenerationAssetId(model.policyGenerationAssetId);
            this.definition(model.definition);
            this.rawTextFragment(model.rawTextFragment);
            this.findings(model.findings);
        }

        public final String getPolicyGenerationAssetId() {
            return this.policyGenerationAssetId;
        }

        public final void setPolicyGenerationAssetId(String policyGenerationAssetId) {
            this.policyGenerationAssetId = policyGenerationAssetId;
        }

        @Override
        public final Builder policyGenerationAssetId(String policyGenerationAssetId) {
            this.policyGenerationAssetId = policyGenerationAssetId;
            return this;
        }

        public final PolicyDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(PolicyDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PolicyDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getRawTextFragment() {
            return this.rawTextFragment;
        }

        public final void setRawTextFragment(String rawTextFragment) {
            this.rawTextFragment = rawTextFragment;
        }

        @Override
        public final Builder rawTextFragment(String rawTextFragment) {
            this.rawTextFragment = rawTextFragment;
            return this;
        }

        public final List<Finding.Builder> getFindings() {
            List<Finding.Builder> result = FindingsCopier.copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = FindingsCopier.copyFromBuilder(findings);
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = FindingsCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (Finding)((Finding.Builder)Finding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PolicyGenerationAsset build() {
            return new PolicyGenerationAsset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyGenerationAsset> {
        public Builder policyGenerationAssetId(String var1);

        public Builder definition(PolicyDefinition var1);

        default public Builder definition(Consumer<PolicyDefinition.Builder> definition) {
            return this.definition((PolicyDefinition)((PolicyDefinition.Builder)PolicyDefinition.builder().applyMutation(definition)).build());
        }

        public Builder rawTextFragment(String var1);

        public Builder findings(Collection<Finding> var1);

        public Builder findings(Finding ... var1);

        public Builder findings(Consumer<Finding.Builder> ... var1);
    }
}

