/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DataSourceConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorListCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorReference;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationExecutionStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Rule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOnlineEvaluationConfigRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, UpdateOnlineEvaluationConfigRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateOnlineEvaluationConfigRequest.getter(UpdateOnlineEvaluationConfigRequest::clientToken)).setter(UpdateOnlineEvaluationConfigRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigId").getter(UpdateOnlineEvaluationConfigRequest.getter(UpdateOnlineEvaluationConfigRequest::onlineEvaluationConfigId)).setter(UpdateOnlineEvaluationConfigRequest.setter(Builder::onlineEvaluationConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("onlineEvaluationConfigId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateOnlineEvaluationConfigRequest.getter(UpdateOnlineEvaluationConfigRequest::description)).setter(UpdateOnlineEvaluationConfigRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Rule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rule").getter(UpdateOnlineEvaluationConfigRequest.getter(UpdateOnlineEvaluationConfigRequest::rule)).setter(UpdateOnlineEvaluationConfigRequest.setter(Builder::rule)).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()}).build();
    private static final SdkField<DataSourceConfig> DATA_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSourceConfig").getter(UpdateOnlineEvaluationConfigRequest.getter(UpdateOnlineEvaluationConfigRequest::dataSourceConfig)).setter(UpdateOnlineEvaluationConfigRequest.setter(Builder::dataSourceConfig)).constructor(DataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfig").build()}).build();
    private static final SdkField<List<EvaluatorReference>> EVALUATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluators").getter(UpdateOnlineEvaluationConfigRequest.getter(UpdateOnlineEvaluationConfigRequest::evaluators)).setter(UpdateOnlineEvaluationConfigRequest.setter(Builder::evaluators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluatorReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATION_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationExecutionRoleArn").getter(UpdateOnlineEvaluationConfigRequest.getter(UpdateOnlineEvaluationConfigRequest::evaluationExecutionRoleArn)).setter(UpdateOnlineEvaluationConfigRequest.setter(Builder::evaluationExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationExecutionRoleArn").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStatus").getter(UpdateOnlineEvaluationConfigRequest.getter(UpdateOnlineEvaluationConfigRequest::executionStatusAsString)).setter(UpdateOnlineEvaluationConfigRequest.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ONLINE_EVALUATION_CONFIG_ID_FIELD, DESCRIPTION_FIELD, RULE_FIELD, DATA_SOURCE_CONFIG_FIELD, EVALUATORS_FIELD, EVALUATION_EXECUTION_ROLE_ARN_FIELD, EXECUTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOnlineEvaluationConfigRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String onlineEvaluationConfigId;
    private final String description;
    private final Rule rule;
    private final DataSourceConfig dataSourceConfig;
    private final List<EvaluatorReference> evaluators;
    private final String evaluationExecutionRoleArn;
    private final String executionStatus;

    private UpdateOnlineEvaluationConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.onlineEvaluationConfigId = builder.onlineEvaluationConfigId;
        this.description = builder.description;
        this.rule = builder.rule;
        this.dataSourceConfig = builder.dataSourceConfig;
        this.evaluators = builder.evaluators;
        this.evaluationExecutionRoleArn = builder.evaluationExecutionRoleArn;
        this.executionStatus = builder.executionStatus;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String onlineEvaluationConfigId() {
        return this.onlineEvaluationConfigId;
    }

    public final String description() {
        return this.description;
    }

    public final Rule rule() {
        return this.rule;
    }

    public final DataSourceConfig dataSourceConfig() {
        return this.dataSourceConfig;
    }

    public final boolean hasEvaluators() {
        return this.evaluators != null && !(this.evaluators instanceof SdkAutoConstructList);
    }

    public final List<EvaluatorReference> evaluators() {
        return this.evaluators;
    }

    public final String evaluationExecutionRoleArn() {
        return this.evaluationExecutionRoleArn;
    }

    public final OnlineEvaluationExecutionStatus executionStatus() {
        return OnlineEvaluationExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluators() ? this.evaluators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOnlineEvaluationConfigRequest)) {
            return false;
        }
        UpdateOnlineEvaluationConfigRequest other = (UpdateOnlineEvaluationConfigRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.onlineEvaluationConfigId(), other.onlineEvaluationConfigId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.rule(), other.rule()) && Objects.equals(this.dataSourceConfig(), other.dataSourceConfig()) && this.hasEvaluators() == other.hasEvaluators() && Objects.equals(this.evaluators(), other.evaluators()) && Objects.equals(this.evaluationExecutionRoleArn(), other.evaluationExecutionRoleArn()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOnlineEvaluationConfigRequest").add("ClientToken", (Object)this.clientToken()).add("OnlineEvaluationConfigId", (Object)this.onlineEvaluationConfigId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Rule", (Object)this.rule()).add("DataSourceConfig", (Object)this.dataSourceConfig()).add("Evaluators", this.hasEvaluators() ? this.evaluators() : null).add("EvaluationExecutionRoleArn", (Object)this.evaluationExecutionRoleArn()).add("ExecutionStatus", (Object)this.executionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "onlineEvaluationConfigId": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "dataSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfig()));
            }
            case "evaluators": {
                return Optional.ofNullable(clazz.cast(this.evaluators()));
            }
            case "evaluationExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationExecutionRoleArn()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("onlineEvaluationConfigId", ONLINE_EVALUATION_CONFIG_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("rule", RULE_FIELD);
        map.put("dataSourceConfig", DATA_SOURCE_CONFIG_FIELD);
        map.put("evaluators", EVALUATORS_FIELD);
        map.put("evaluationExecutionRoleArn", EVALUATION_EXECUTION_ROLE_ARN_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOnlineEvaluationConfigRequest, T> g) {
        return obj -> g.apply((UpdateOnlineEvaluationConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String onlineEvaluationConfigId;
        private String description;
        private Rule rule;
        private DataSourceConfig dataSourceConfig;
        private List<EvaluatorReference> evaluators = DefaultSdkAutoConstructList.getInstance();
        private String evaluationExecutionRoleArn;
        private String executionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOnlineEvaluationConfigRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.onlineEvaluationConfigId(model.onlineEvaluationConfigId);
            this.description(model.description);
            this.rule(model.rule);
            this.dataSourceConfig(model.dataSourceConfig);
            this.evaluators(model.evaluators);
            this.evaluationExecutionRoleArn(model.evaluationExecutionRoleArn);
            this.executionStatus(model.executionStatus);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOnlineEvaluationConfigId() {
            return this.onlineEvaluationConfigId;
        }

        public final void setOnlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
        }

        @Override
        public final Builder onlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Rule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final DataSourceConfig.Builder getDataSourceConfig() {
            return this.dataSourceConfig != null ? this.dataSourceConfig.toBuilder() : null;
        }

        public final void setDataSourceConfig(DataSourceConfig.BuilderImpl dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig != null ? dataSourceConfig.build() : null;
        }

        @Override
        public final Builder dataSourceConfig(DataSourceConfig dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig;
            return this;
        }

        public final List<EvaluatorReference.Builder> getEvaluators() {
            List<EvaluatorReference.Builder> result = EvaluatorListCopier.copyToBuilder(this.evaluators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluators(Collection<EvaluatorReference.BuilderImpl> evaluators) {
            this.evaluators = EvaluatorListCopier.copyFromBuilder(evaluators);
        }

        @Override
        public final Builder evaluators(Collection<EvaluatorReference> evaluators) {
            this.evaluators = EvaluatorListCopier.copy(evaluators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluators(EvaluatorReference ... evaluators) {
            this.evaluators(Arrays.asList(evaluators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluators(Consumer<EvaluatorReference.Builder> ... evaluators) {
            this.evaluators(Stream.of(evaluators).map(c -> (EvaluatorReference)((EvaluatorReference.Builder)EvaluatorReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEvaluationExecutionRoleArn() {
            return this.evaluationExecutionRoleArn;
        }

        public final void setEvaluationExecutionRoleArn(String evaluationExecutionRoleArn) {
            this.evaluationExecutionRoleArn = evaluationExecutionRoleArn;
        }

        @Override
        public final Builder evaluationExecutionRoleArn(String evaluationExecutionRoleArn) {
            this.evaluationExecutionRoleArn = evaluationExecutionRoleArn;
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(OnlineEvaluationExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOnlineEvaluationConfigRequest build() {
            return new UpdateOnlineEvaluationConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOnlineEvaluationConfigRequest> {
        public Builder clientToken(String var1);

        public Builder onlineEvaluationConfigId(String var1);

        public Builder description(String var1);

        public Builder rule(Rule var1);

        default public Builder rule(Consumer<Rule.Builder> rule) {
            return this.rule((Rule)((Rule.Builder)Rule.builder().applyMutation(rule)).build());
        }

        public Builder dataSourceConfig(DataSourceConfig var1);

        default public Builder dataSourceConfig(Consumer<DataSourceConfig.Builder> dataSourceConfig) {
            return this.dataSourceConfig((DataSourceConfig)((DataSourceConfig.Builder)DataSourceConfig.builder().applyMutation(dataSourceConfig)).build());
        }

        public Builder evaluators(Collection<EvaluatorReference> var1);

        public Builder evaluators(EvaluatorReference ... var1);

        public Builder evaluators(Consumer<EvaluatorReference.Builder> ... var1);

        public Builder evaluationExecutionRoleArn(String var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(OnlineEvaluationExecutionStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

