/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CredentialProviderVendorType {
    GOOGLE_OAUTH2("GoogleOauth2"),
    GITHUB_OAUTH2("GithubOauth2"),
    SLACK_OAUTH2("SlackOauth2"),
    SALESFORCE_OAUTH2("SalesforceOauth2"),
    MICROSOFT_OAUTH2("MicrosoftOauth2"),
    CUSTOM_OAUTH2("CustomOauth2"),
    ATLASSIAN_OAUTH2("AtlassianOauth2"),
    LINKEDIN_OAUTH2("LinkedinOauth2"),
    X_OAUTH2("XOauth2"),
    OKTA_OAUTH2("OktaOauth2"),
    ONE_LOGIN_OAUTH2("OneLoginOauth2"),
    PING_ONE_OAUTH2("PingOneOauth2"),
    FACEBOOK_OAUTH2("FacebookOauth2"),
    YANDEX_OAUTH2("YandexOauth2"),
    REDDIT_OAUTH2("RedditOauth2"),
    ZOOM_OAUTH2("ZoomOauth2"),
    TWITCH_OAUTH2("TwitchOauth2"),
    SPOTIFY_OAUTH2("SpotifyOauth2"),
    DROPBOX_OAUTH2("DropboxOauth2"),
    NOTION_OAUTH2("NotionOauth2"),
    HUBSPOT_OAUTH2("HubspotOauth2"),
    CYBER_ARK_OAUTH2("CyberArkOauth2"),
    FUSION_AUTH_OAUTH2("FusionAuthOauth2"),
    AUTH0_OAUTH2("Auth0Oauth2"),
    COGNITO_OAUTH2("CognitoOauth2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CredentialProviderVendorType> VALUE_MAP;
    private final String value;

    private CredentialProviderVendorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CredentialProviderVendorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CredentialProviderVendorType> knownValues() {
        EnumSet<CredentialProviderVendorType> knownValues = EnumSet.allOf(CredentialProviderVendorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CredentialProviderVendorType.class, CredentialProviderVendorType::toString);
    }
}

