/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyConsolidationConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyExtractionConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyReflectionConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifySelfManagedConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyStrategyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModifyStrategyConfiguration> {
    private static final SdkField<ModifyExtractionConfiguration> EXTRACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("extraction").getter(ModifyStrategyConfiguration.getter(ModifyStrategyConfiguration::extraction)).setter(ModifyStrategyConfiguration.setter(Builder::extraction)).constructor(ModifyExtractionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()}).build();
    private static final SdkField<ModifyConsolidationConfiguration> CONSOLIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("consolidation").getter(ModifyStrategyConfiguration.getter(ModifyStrategyConfiguration::consolidation)).setter(ModifyStrategyConfiguration.setter(Builder::consolidation)).constructor(ModifyConsolidationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consolidation").build()}).build();
    private static final SdkField<ModifyReflectionConfiguration> REFLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reflection").getter(ModifyStrategyConfiguration.getter(ModifyStrategyConfiguration::reflection)).setter(ModifyStrategyConfiguration.setter(Builder::reflection)).constructor(ModifyReflectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reflection").build()}).build();
    private static final SdkField<ModifySelfManagedConfiguration> SELF_MANAGED_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("selfManagedConfiguration").getter(ModifyStrategyConfiguration.getter(ModifyStrategyConfiguration::selfManagedConfiguration)).setter(ModifyStrategyConfiguration.setter(Builder::selfManagedConfiguration)).constructor(ModifySelfManagedConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfManagedConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD, CONSOLIDATION_FIELD, REFLECTION_FIELD, SELF_MANAGED_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyStrategyConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ModifyExtractionConfiguration extraction;
    private final ModifyConsolidationConfiguration consolidation;
    private final ModifyReflectionConfiguration reflection;
    private final ModifySelfManagedConfiguration selfManagedConfiguration;

    private ModifyStrategyConfiguration(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.consolidation = builder.consolidation;
        this.reflection = builder.reflection;
        this.selfManagedConfiguration = builder.selfManagedConfiguration;
    }

    public final ModifyExtractionConfiguration extraction() {
        return this.extraction;
    }

    public final ModifyConsolidationConfiguration consolidation() {
        return this.consolidation;
    }

    public final ModifyReflectionConfiguration reflection() {
        return this.reflection;
    }

    public final ModifySelfManagedConfiguration selfManagedConfiguration() {
        return this.selfManagedConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extraction());
        hashCode = 31 * hashCode + Objects.hashCode(this.consolidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.reflection());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyStrategyConfiguration)) {
            return false;
        }
        ModifyStrategyConfiguration other = (ModifyStrategyConfiguration)obj;
        return Objects.equals(this.extraction(), other.extraction()) && Objects.equals(this.consolidation(), other.consolidation()) && Objects.equals(this.reflection(), other.reflection()) && Objects.equals(this.selfManagedConfiguration(), other.selfManagedConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyStrategyConfiguration").add("Extraction", (Object)this.extraction()).add("Consolidation", (Object)this.consolidation()).add("Reflection", (Object)this.reflection()).add("SelfManagedConfiguration", (Object)this.selfManagedConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extraction": {
                return Optional.ofNullable(clazz.cast(this.extraction()));
            }
            case "consolidation": {
                return Optional.ofNullable(clazz.cast(this.consolidation()));
            }
            case "reflection": {
                return Optional.ofNullable(clazz.cast(this.reflection()));
            }
            case "selfManagedConfiguration": {
                return Optional.ofNullable(clazz.cast(this.selfManagedConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("consolidation", CONSOLIDATION_FIELD);
        map.put("reflection", REFLECTION_FIELD);
        map.put("selfManagedConfiguration", SELF_MANAGED_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyStrategyConfiguration, T> g) {
        return obj -> g.apply((ModifyStrategyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ModifyExtractionConfiguration extraction;
        private ModifyConsolidationConfiguration consolidation;
        private ModifyReflectionConfiguration reflection;
        private ModifySelfManagedConfiguration selfManagedConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyStrategyConfiguration model) {
            this.extraction(model.extraction);
            this.consolidation(model.consolidation);
            this.reflection(model.reflection);
            this.selfManagedConfiguration(model.selfManagedConfiguration);
        }

        public final ModifyExtractionConfiguration.Builder getExtraction() {
            return this.extraction != null ? this.extraction.toBuilder() : null;
        }

        public final void setExtraction(ModifyExtractionConfiguration.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(ModifyExtractionConfiguration extraction) {
            this.extraction = extraction;
            return this;
        }

        public final ModifyConsolidationConfiguration.Builder getConsolidation() {
            return this.consolidation != null ? this.consolidation.toBuilder() : null;
        }

        public final void setConsolidation(ModifyConsolidationConfiguration.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(ModifyConsolidationConfiguration consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        public final ModifyReflectionConfiguration.Builder getReflection() {
            return this.reflection != null ? this.reflection.toBuilder() : null;
        }

        public final void setReflection(ModifyReflectionConfiguration.BuilderImpl reflection) {
            this.reflection = reflection != null ? reflection.build() : null;
        }

        @Override
        public final Builder reflection(ModifyReflectionConfiguration reflection) {
            this.reflection = reflection;
            return this;
        }

        public final ModifySelfManagedConfiguration.Builder getSelfManagedConfiguration() {
            return this.selfManagedConfiguration != null ? this.selfManagedConfiguration.toBuilder() : null;
        }

        public final void setSelfManagedConfiguration(ModifySelfManagedConfiguration.BuilderImpl selfManagedConfiguration) {
            this.selfManagedConfiguration = selfManagedConfiguration != null ? selfManagedConfiguration.build() : null;
        }

        @Override
        public final Builder selfManagedConfiguration(ModifySelfManagedConfiguration selfManagedConfiguration) {
            this.selfManagedConfiguration = selfManagedConfiguration;
            return this;
        }

        public ModifyStrategyConfiguration build() {
            return new ModifyStrategyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModifyStrategyConfiguration> {
        public Builder extraction(ModifyExtractionConfiguration var1);

        default public Builder extraction(Consumer<ModifyExtractionConfiguration.Builder> extraction) {
            return this.extraction((ModifyExtractionConfiguration)((ModifyExtractionConfiguration.Builder)ModifyExtractionConfiguration.builder().applyMutation(extraction)).build());
        }

        public Builder consolidation(ModifyConsolidationConfiguration var1);

        default public Builder consolidation(Consumer<ModifyConsolidationConfiguration.Builder> consolidation) {
            return this.consolidation((ModifyConsolidationConfiguration)((ModifyConsolidationConfiguration.Builder)ModifyConsolidationConfiguration.builder().applyMutation(consolidation)).build());
        }

        public Builder reflection(ModifyReflectionConfiguration var1);

        default public Builder reflection(Consumer<ModifyReflectionConfiguration.Builder> reflection) {
            return this.reflection((ModifyReflectionConfiguration)((ModifyReflectionConfiguration.Builder)ModifyReflectionConfiguration.builder().applyMutation(reflection)).build());
        }

        public Builder selfManagedConfiguration(ModifySelfManagedConfiguration var1);

        default public Builder selfManagedConfiguration(Consumer<ModifySelfManagedConfiguration.Builder> selfManagedConfiguration) {
            return this.selfManagedConfiguration((ModifySelfManagedConfiguration)((ModifySelfManagedConfiguration.Builder)ModifySelfManagedConfiguration.builder().applyMutation(selfManagedConfiguration)).build());
        }
    }
}

