/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyEngine;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyEnginesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyEnginesResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, ListPolicyEnginesResponse> {
    private static final SdkField<List<PolicyEngine>> POLICY_ENGINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyEngines").getter(ListPolicyEnginesResponse.getter(ListPolicyEnginesResponse::policyEngines)).setter(ListPolicyEnginesResponse.setter(Builder::policyEngines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyEngines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyEngine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPolicyEnginesResponse.getter(ListPolicyEnginesResponse::nextToken)).setter(ListPolicyEnginesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ENGINES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPolicyEnginesResponse.memberNameToFieldInitializer();
    private final List<PolicyEngine> policyEngines;
    private final String nextToken;

    private ListPolicyEnginesResponse(BuilderImpl builder) {
        super(builder);
        this.policyEngines = builder.policyEngines;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPolicyEngines() {
        return this.policyEngines != null && !(this.policyEngines instanceof SdkAutoConstructList);
    }

    public final List<PolicyEngine> policyEngines() {
        return this.policyEngines;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyEngines() ? this.policyEngines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyEnginesResponse)) {
            return false;
        }
        ListPolicyEnginesResponse other = (ListPolicyEnginesResponse)((Object)obj);
        return this.hasPolicyEngines() == other.hasPolicyEngines() && Objects.equals(this.policyEngines(), other.policyEngines()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPolicyEnginesResponse").add("PolicyEngines", this.hasPolicyEngines() ? this.policyEngines() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyEngines": {
                return Optional.ofNullable(clazz.cast(this.policyEngines()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyEngines", POLICY_ENGINES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyEnginesResponse, T> g) {
        return obj -> g.apply((ListPolicyEnginesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private List<PolicyEngine> policyEngines = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyEnginesResponse model) {
            super(model);
            this.policyEngines(model.policyEngines);
            this.nextToken(model.nextToken);
        }

        public final List<PolicyEngine.Builder> getPolicyEngines() {
            List<PolicyEngine.Builder> result = PolicyEnginesCopier.copyToBuilder(this.policyEngines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyEngines(Collection<PolicyEngine.BuilderImpl> policyEngines) {
            this.policyEngines = PolicyEnginesCopier.copyFromBuilder(policyEngines);
        }

        @Override
        public final Builder policyEngines(Collection<PolicyEngine> policyEngines) {
            this.policyEngines = PolicyEnginesCopier.copy(policyEngines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyEngines(PolicyEngine ... policyEngines) {
            this.policyEngines(Arrays.asList(policyEngines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyEngines(Consumer<PolicyEngine.Builder> ... policyEngines) {
            this.policyEngines(Stream.of(policyEngines).map(c -> (PolicyEngine)((PolicyEngine.Builder)PolicyEngine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPolicyEnginesResponse build() {
            return new ListPolicyEnginesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyEnginesResponse> {
        public Builder policyEngines(Collection<PolicyEngine> var1);

        public Builder policyEngines(PolicyEngine ... var1);

        public Builder policyEngines(Consumer<PolicyEngine.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

