/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RestApiMethod;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RestApiMethodsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiGatewayToolFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiGatewayToolFilter> {
    private static final SdkField<String> FILTER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPath").getter(ApiGatewayToolFilter.getter(ApiGatewayToolFilter::filterPath)).setter(ApiGatewayToolFilter.setter(Builder::filterPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPath").build()}).build();
    private static final SdkField<List<String>> METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("methods").getter(ApiGatewayToolFilter.getter(ApiGatewayToolFilter::methodsAsStrings)).setter(ApiGatewayToolFilter.setter(Builder::methodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_PATH_FIELD, METHODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiGatewayToolFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterPath;
    private final List<String> methods;

    private ApiGatewayToolFilter(BuilderImpl builder) {
        this.filterPath = builder.filterPath;
        this.methods = builder.methods;
    }

    public final String filterPath() {
        return this.filterPath;
    }

    public final List<RestApiMethod> methods() {
        return RestApiMethodsCopier.copyStringToEnum(this.methods);
    }

    public final boolean hasMethods() {
        return this.methods != null && !(this.methods instanceof SdkAutoConstructList);
    }

    public final List<String> methodsAsStrings() {
        return this.methods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMethods() ? this.methodsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiGatewayToolFilter)) {
            return false;
        }
        ApiGatewayToolFilter other = (ApiGatewayToolFilter)obj;
        return Objects.equals(this.filterPath(), other.filterPath()) && this.hasMethods() == other.hasMethods() && Objects.equals(this.methodsAsStrings(), other.methodsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ApiGatewayToolFilter").add("FilterPath", (Object)this.filterPath()).add("Methods", this.hasMethods() ? this.methodsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterPath": {
                return Optional.ofNullable(clazz.cast(this.filterPath()));
            }
            case "methods": {
                return Optional.ofNullable(clazz.cast(this.methodsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterPath", FILTER_PATH_FIELD);
        map.put("methods", METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiGatewayToolFilter, T> g) {
        return obj -> g.apply((ApiGatewayToolFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterPath;
        private List<String> methods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApiGatewayToolFilter model) {
            this.filterPath(model.filterPath);
            this.methodsWithStrings(model.methods);
        }

        public final String getFilterPath() {
            return this.filterPath;
        }

        public final void setFilterPath(String filterPath) {
            this.filterPath = filterPath;
        }

        @Override
        public final Builder filterPath(String filterPath) {
            this.filterPath = filterPath;
            return this;
        }

        public final Collection<String> getMethods() {
            if (this.methods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.methods;
        }

        public final void setMethods(Collection<String> methods) {
            this.methods = RestApiMethodsCopier.copy(methods);
        }

        @Override
        public final Builder methodsWithStrings(Collection<String> methods) {
            this.methods = RestApiMethodsCopier.copy(methods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methodsWithStrings(String ... methods) {
            this.methodsWithStrings(Arrays.asList(methods));
            return this;
        }

        @Override
        public final Builder methods(Collection<RestApiMethod> methods) {
            this.methods = RestApiMethodsCopier.copyEnumToString(methods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methods(RestApiMethod ... methods) {
            this.methods(Arrays.asList(methods));
            return this;
        }

        public ApiGatewayToolFilter build() {
            return new ApiGatewayToolFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiGatewayToolFilter> {
        public Builder filterPath(String var1);

        public Builder methodsWithStrings(Collection<String> var1);

        public Builder methodsWithStrings(String ... var1);

        public Builder methods(Collection<RestApiMethod> var1);

        public Builder methods(RestApiMethod ... var1);
    }
}

