/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FindingType {
    VALID("VALID"),
    INVALID("INVALID"),
    NOT_TRANSLATABLE("NOT_TRANSLATABLE"),
    ALLOW_ALL("ALLOW_ALL"),
    ALLOW_NONE("ALLOW_NONE"),
    DENY_ALL("DENY_ALL"),
    DENY_NONE("DENY_NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FindingType> VALUE_MAP;
    private final String value;

    private FindingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingType> knownValues() {
        EnumSet<FindingType> knownValues = EnumSet.allOf(FindingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FindingType.class, FindingType::toString);
    }
}

