/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.StatusReasonsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteGatewayTargetResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, DeleteGatewayTargetResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayArn").getter(DeleteGatewayTargetResponse.getter(DeleteGatewayTargetResponse::gatewayArn)).setter(DeleteGatewayTargetResponse.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetId").getter(DeleteGatewayTargetResponse.getter(DeleteGatewayTargetResponse::targetId)).setter(DeleteGatewayTargetResponse.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteGatewayTargetResponse.getter(DeleteGatewayTargetResponse::statusAsString)).setter(DeleteGatewayTargetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusReasons").getter(DeleteGatewayTargetResponse.getter(DeleteGatewayTargetResponse::statusReasons)).setter(DeleteGatewayTargetResponse.setter(Builder::statusReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, TARGET_ID_FIELD, STATUS_FIELD, STATUS_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteGatewayTargetResponse.memberNameToFieldInitializer();
    private final String gatewayArn;
    private final String targetId;
    private final String status;
    private final List<String> statusReasons;

    private DeleteGatewayTargetResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayArn = builder.gatewayArn;
        this.targetId = builder.targetId;
        this.status = builder.status;
        this.statusReasons = builder.statusReasons;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final TargetStatus status() {
        return TargetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasStatusReasons() {
        return this.statusReasons != null && !(this.statusReasons instanceof SdkAutoConstructList);
    }

    public final List<String> statusReasons() {
        return this.statusReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasons() ? this.statusReasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGatewayTargetResponse)) {
            return false;
        }
        DeleteGatewayTargetResponse other = (DeleteGatewayTargetResponse)((Object)obj);
        return Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusReasons() == other.hasStatusReasons() && Objects.equals(this.statusReasons(), other.statusReasons());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteGatewayTargetResponse").add("GatewayArn", (Object)this.gatewayArn()).add("TargetId", (Object)this.targetId()).add("Status", (Object)this.statusAsString()).add("StatusReasons", this.hasStatusReasons() ? this.statusReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReasons": {
                return Optional.ofNullable(clazz.cast(this.statusReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("targetId", TARGET_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGatewayTargetResponse, T> g) {
        return obj -> g.apply((DeleteGatewayTargetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String gatewayArn;
        private String targetId;
        private String status;
        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGatewayTargetResponse model) {
            super(model);
            this.gatewayArn(model.gatewayArn);
            this.targetId(model.targetId);
            this.status(model.status);
            this.statusReasons(model.statusReasons);
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (this.statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(String ... statusReasons) {
            this.statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        @Override
        public DeleteGatewayTargetResponse build() {
            return new DeleteGatewayTargetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteGatewayTargetResponse> {
        public Builder gatewayArn(String var1);

        public Builder targetId(String var1);

        public Builder status(String var1);

        public Builder status(TargetStatus var1);

        public Builder statusReasons(Collection<String> var1);

        public Builder statusReasons(String ... var1);
    }
}

