/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ResponseListTypeCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TokenEndpointAuthMethodsTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Oauth2AuthorizationServerMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Oauth2AuthorizationServerMetadata> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(Oauth2AuthorizationServerMetadata.getter(Oauth2AuthorizationServerMetadata::issuer)).setter(Oauth2AuthorizationServerMetadata.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationEndpoint").getter(Oauth2AuthorizationServerMetadata.getter(Oauth2AuthorizationServerMetadata::authorizationEndpoint)).setter(Oauth2AuthorizationServerMetadata.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationEndpoint").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenEndpoint").getter(Oauth2AuthorizationServerMetadata.getter(Oauth2AuthorizationServerMetadata::tokenEndpoint)).setter(Oauth2AuthorizationServerMetadata.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpoint").build()}).build();
    private static final SdkField<List<String>> RESPONSE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("responseTypes").getter(Oauth2AuthorizationServerMetadata.getter(Oauth2AuthorizationServerMetadata::responseTypes)).setter(Oauth2AuthorizationServerMetadata.setter(Builder::responseTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TOKEN_ENDPOINT_AUTH_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tokenEndpointAuthMethods").getter(Oauth2AuthorizationServerMetadata.getter(Oauth2AuthorizationServerMetadata::tokenEndpointAuthMethods)).setter(Oauth2AuthorizationServerMetadata.setter(Builder::tokenEndpointAuthMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpointAuthMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, RESPONSE_TYPES_FIELD, TOKEN_ENDPOINT_AUTH_METHODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Oauth2AuthorizationServerMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String issuer;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final List<String> responseTypes;
    private final List<String> tokenEndpointAuthMethods;

    private Oauth2AuthorizationServerMetadata(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.responseTypes = builder.responseTypes;
        this.tokenEndpointAuthMethods = builder.tokenEndpointAuthMethods;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public final boolean hasResponseTypes() {
        return this.responseTypes != null && !(this.responseTypes instanceof SdkAutoConstructList);
    }

    public final List<String> responseTypes() {
        return this.responseTypes;
    }

    public final boolean hasTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods != null && !(this.tokenEndpointAuthMethods instanceof SdkAutoConstructList);
    }

    public final List<String> tokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTypes() ? this.responseTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenEndpointAuthMethods() ? this.tokenEndpointAuthMethods() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Oauth2AuthorizationServerMetadata)) {
            return false;
        }
        Oauth2AuthorizationServerMetadata other = (Oauth2AuthorizationServerMetadata)obj;
        return Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint()) && this.hasResponseTypes() == other.hasResponseTypes() && Objects.equals(this.responseTypes(), other.responseTypes()) && this.hasTokenEndpointAuthMethods() == other.hasTokenEndpointAuthMethods() && Objects.equals(this.tokenEndpointAuthMethods(), other.tokenEndpointAuthMethods());
    }

    public final String toString() {
        return ToString.builder((String)"Oauth2AuthorizationServerMetadata").add("Issuer", (Object)this.issuer()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("TokenEndpoint", (Object)this.tokenEndpoint()).add("ResponseTypes", this.hasResponseTypes() ? this.responseTypes() : null).add("TokenEndpointAuthMethods", this.hasTokenEndpointAuthMethods() ? this.tokenEndpointAuthMethods() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "authorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "tokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
            case "responseTypes": {
                return Optional.ofNullable(clazz.cast(this.responseTypes()));
            }
            case "tokenEndpointAuthMethods": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpointAuthMethods()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("issuer", ISSUER_FIELD);
        map.put("authorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("tokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("responseTypes", RESPONSE_TYPES_FIELD);
        map.put("tokenEndpointAuthMethods", TOKEN_ENDPOINT_AUTH_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Oauth2AuthorizationServerMetadata, T> g) {
        return obj -> g.apply((Oauth2AuthorizationServerMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issuer;
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private List<String> responseTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> tokenEndpointAuthMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Oauth2AuthorizationServerMetadata model) {
            this.issuer(model.issuer);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.tokenEndpoint(model.tokenEndpoint);
            this.responseTypes(model.responseTypes);
            this.tokenEndpointAuthMethods(model.tokenEndpointAuthMethods);
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final Collection<String> getResponseTypes() {
            if (this.responseTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.responseTypes;
        }

        public final void setResponseTypes(Collection<String> responseTypes) {
            this.responseTypes = ResponseListTypeCopier.copy(responseTypes);
        }

        @Override
        public final Builder responseTypes(Collection<String> responseTypes) {
            this.responseTypes = ResponseListTypeCopier.copy(responseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTypes(String ... responseTypes) {
            this.responseTypes(Arrays.asList(responseTypes));
            return this;
        }

        public final Collection<String> getTokenEndpointAuthMethods() {
            if (this.tokenEndpointAuthMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenEndpointAuthMethods;
        }

        public final void setTokenEndpointAuthMethods(Collection<String> tokenEndpointAuthMethods) {
            this.tokenEndpointAuthMethods = TokenEndpointAuthMethodsTypeCopier.copy(tokenEndpointAuthMethods);
        }

        @Override
        public final Builder tokenEndpointAuthMethods(Collection<String> tokenEndpointAuthMethods) {
            this.tokenEndpointAuthMethods = TokenEndpointAuthMethodsTypeCopier.copy(tokenEndpointAuthMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenEndpointAuthMethods(String ... tokenEndpointAuthMethods) {
            this.tokenEndpointAuthMethods(Arrays.asList(tokenEndpointAuthMethods));
            return this;
        }

        public Oauth2AuthorizationServerMetadata build() {
            return new Oauth2AuthorizationServerMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Oauth2AuthorizationServerMetadata> {
        public Builder issuer(String var1);

        public Builder authorizationEndpoint(String var1);

        public Builder tokenEndpoint(String var1);

        public Builder responseTypes(Collection<String> var1);

        public Builder responseTypes(String ... var1);

        public Builder tokenEndpointAuthMethods(Collection<String> var1);

        public Builder tokenEndpointAuthMethods(String ... var1);
    }
}

