/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentRuntimeEndpointStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAgentRuntimeEndpointResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, DeleteAgentRuntimeEndpointResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteAgentRuntimeEndpointResponse.getter(DeleteAgentRuntimeEndpointResponse::statusAsString)).setter(DeleteAgentRuntimeEndpointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeId").getter(DeleteAgentRuntimeEndpointResponse.getter(DeleteAgentRuntimeEndpointResponse::agentRuntimeId)).setter(DeleteAgentRuntimeEndpointResponse.setter(Builder::agentRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeId").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointName").getter(DeleteAgentRuntimeEndpointResponse.getter(DeleteAgentRuntimeEndpointResponse::endpointName)).setter(DeleteAgentRuntimeEndpointResponse.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, AGENT_RUNTIME_ID_FIELD, ENDPOINT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAgentRuntimeEndpointResponse.memberNameToFieldInitializer();
    private final String status;
    private final String agentRuntimeId;
    private final String endpointName;

    private DeleteAgentRuntimeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.agentRuntimeId = builder.agentRuntimeId;
        this.endpointName = builder.endpointName;
    }

    public final AgentRuntimeEndpointStatus status() {
        return AgentRuntimeEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String agentRuntimeId() {
        return this.agentRuntimeId;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgentRuntimeEndpointResponse)) {
            return false;
        }
        DeleteAgentRuntimeEndpointResponse other = (DeleteAgentRuntimeEndpointResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(this.endpointName(), other.endpointName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAgentRuntimeEndpointResponse").add("Status", (Object)this.statusAsString()).add("AgentRuntimeId", (Object)this.agentRuntimeId()).add("EndpointName", (Object)(this.endpointName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "agentRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeId()));
            }
            case "endpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("status", STATUS_FIELD);
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("endpointName", ENDPOINT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgentRuntimeEndpointResponse, T> g) {
        return obj -> g.apply((DeleteAgentRuntimeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String status;
        private String agentRuntimeId;
        private String endpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgentRuntimeEndpointResponse model) {
            super(model);
            this.status(model.status);
            this.agentRuntimeId(model.agentRuntimeId);
            this.endpointName(model.endpointName);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentRuntimeEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        @Override
        public DeleteAgentRuntimeEndpointResponse build() {
            return new DeleteAgentRuntimeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAgentRuntimeEndpointResponse> {
        public Builder status(String var1);

        public Builder status(AgentRuntimeEndpointStatus var1);

        public Builder agentRuntimeId(String var1);

        public Builder endpointName(String var1);
    }
}

