/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TargetSummary;

public class ListGatewayTargetsPublisher
implements SdkPublisher<ListGatewayTargetsResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListGatewayTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGatewayTargetsPublisher(BedrockAgentCoreControlAsyncClient client, ListGatewayTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGatewayTargetsPublisher(BedrockAgentCoreControlAsyncClient client, ListGatewayTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGatewayTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGatewayTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TargetSummary> items() {
        Function<ListGatewayTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGatewayTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGatewayTargetsResponseFetcher
    implements AsyncPageFetcher<ListGatewayTargetsResponse> {
        private ListGatewayTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewayTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGatewayTargetsResponse> nextPage(ListGatewayTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListGatewayTargetsPublisher.this.client.listGatewayTargets(ListGatewayTargetsPublisher.this.firstRequest);
            }
            return ListGatewayTargetsPublisher.this.client.listGatewayTargets((ListGatewayTargetsRequest)((Object)ListGatewayTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

