/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInputListCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMemoryRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, CreateMemoryRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateMemoryRequest.getter(CreateMemoryRequest::clientToken)).setter(CreateMemoryRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateMemoryRequest.getter(CreateMemoryRequest::name)).setter(CreateMemoryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateMemoryRequest.getter(CreateMemoryRequest::description)).setter(CreateMemoryRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKeyArn").getter(CreateMemoryRequest.getter(CreateMemoryRequest::encryptionKeyArn)).setter(CreateMemoryRequest.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()}).build();
    private static final SdkField<String> MEMORY_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryExecutionRoleArn").getter(CreateMemoryRequest.getter(CreateMemoryRequest::memoryExecutionRoleArn)).setter(CreateMemoryRequest.setter(Builder::memoryExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryExecutionRoleArn").build()}).build();
    private static final SdkField<Integer> EVENT_EXPIRY_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("eventExpiryDuration").getter(CreateMemoryRequest.getter(CreateMemoryRequest::eventExpiryDuration)).setter(CreateMemoryRequest.setter(Builder::eventExpiryDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventExpiryDuration").build()}).build();
    private static final SdkField<List<MemoryStrategyInput>> MEMORY_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memoryStrategies").getter(CreateMemoryRequest.getter(CreateMemoryRequest::memoryStrategies)).setter(CreateMemoryRequest.setter(Builder::memoryStrategies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemoryStrategyInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMemoryRequest.getter(CreateMemoryRequest::tags)).setter(CreateMemoryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ENCRYPTION_KEY_ARN_FIELD, MEMORY_EXECUTION_ROLE_ARN_FIELD, EVENT_EXPIRY_DURATION_FIELD, MEMORY_STRATEGIES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMemoryRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String name;
    private final String description;
    private final String encryptionKeyArn;
    private final String memoryExecutionRoleArn;
    private final Integer eventExpiryDuration;
    private final List<MemoryStrategyInput> memoryStrategies;
    private final Map<String, String> tags;

    private CreateMemoryRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.memoryExecutionRoleArn = builder.memoryExecutionRoleArn;
        this.eventExpiryDuration = builder.eventExpiryDuration;
        this.memoryStrategies = builder.memoryStrategies;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final String memoryExecutionRoleArn() {
        return this.memoryExecutionRoleArn;
    }

    public final Integer eventExpiryDuration() {
        return this.eventExpiryDuration;
    }

    public final boolean hasMemoryStrategies() {
        return this.memoryStrategies != null && !(this.memoryStrategies instanceof SdkAutoConstructList);
    }

    public final List<MemoryStrategyInput> memoryStrategies() {
        return this.memoryStrategies;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventExpiryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemoryStrategies() ? this.memoryStrategies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMemoryRequest)) {
            return false;
        }
        CreateMemoryRequest other = (CreateMemoryRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.memoryExecutionRoleArn(), other.memoryExecutionRoleArn()) && Objects.equals(this.eventExpiryDuration(), other.eventExpiryDuration()) && this.hasMemoryStrategies() == other.hasMemoryStrategies() && Objects.equals(this.memoryStrategies(), other.memoryStrategies()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMemoryRequest").add("ClientToken", (Object)this.clientToken()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("MemoryExecutionRoleArn", (Object)this.memoryExecutionRoleArn()).add("EventExpiryDuration", (Object)this.eventExpiryDuration()).add("MemoryStrategies", this.hasMemoryStrategies() ? this.memoryStrategies() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "encryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "memoryExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.memoryExecutionRoleArn()));
            }
            case "eventExpiryDuration": {
                return Optional.ofNullable(clazz.cast(this.eventExpiryDuration()));
            }
            case "memoryStrategies": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategies()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("memoryExecutionRoleArn", MEMORY_EXECUTION_ROLE_ARN_FIELD);
        map.put("eventExpiryDuration", EVENT_EXPIRY_DURATION_FIELD);
        map.put("memoryStrategies", MEMORY_STRATEGIES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMemoryRequest, T> g) {
        return obj -> g.apply((CreateMemoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String name;
        private String description;
        private String encryptionKeyArn;
        private String memoryExecutionRoleArn;
        private Integer eventExpiryDuration;
        private List<MemoryStrategyInput> memoryStrategies = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMemoryRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.description(model.description);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.memoryExecutionRoleArn(model.memoryExecutionRoleArn);
            this.eventExpiryDuration(model.eventExpiryDuration);
            this.memoryStrategies(model.memoryStrategies);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getMemoryExecutionRoleArn() {
            return this.memoryExecutionRoleArn;
        }

        public final void setMemoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
        }

        @Override
        public final Builder memoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
            return this;
        }

        public final Integer getEventExpiryDuration() {
            return this.eventExpiryDuration;
        }

        public final void setEventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
        }

        @Override
        public final Builder eventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
            return this;
        }

        public final List<MemoryStrategyInput.Builder> getMemoryStrategies() {
            List<MemoryStrategyInput.Builder> result = MemoryStrategyInputListCopier.copyToBuilder(this.memoryStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemoryStrategies(Collection<MemoryStrategyInput.BuilderImpl> memoryStrategies) {
            this.memoryStrategies = MemoryStrategyInputListCopier.copyFromBuilder(memoryStrategies);
        }

        @Override
        public final Builder memoryStrategies(Collection<MemoryStrategyInput> memoryStrategies) {
            this.memoryStrategies = MemoryStrategyInputListCopier.copy(memoryStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryStrategies(MemoryStrategyInput ... memoryStrategies) {
            this.memoryStrategies(Arrays.asList(memoryStrategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryStrategies(Consumer<MemoryStrategyInput.Builder> ... memoryStrategies) {
            this.memoryStrategies(Stream.of(memoryStrategies).map(c -> (MemoryStrategyInput)((MemoryStrategyInput.Builder)MemoryStrategyInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMemoryRequest build() {
            return new CreateMemoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMemoryRequest> {
        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder memoryExecutionRoleArn(String var1);

        public Builder eventExpiryDuration(Integer var1);

        public Builder memoryStrategies(Collection<MemoryStrategyInput> var1);

        public Builder memoryStrategies(MemoryStrategyInput ... var1);

        public Builder memoryStrategies(Consumer<MemoryStrategyInput.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

