/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemorySummary;

public class ListMemoriesIterable
implements SdkIterable<ListMemoriesResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListMemoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMemoriesIterable(BedrockAgentCoreControlClient client, ListMemoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMemoriesResponseFetcher();
    }

    public Iterator<ListMemoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MemorySummary> memories() {
        Function<ListMemoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.memories() != null) {
                return response.memories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMemoriesResponseFetcher
    implements SyncPageFetcher<ListMemoriesResponse> {
        private ListMemoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListMemoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMemoriesResponse nextPage(ListMemoriesResponse previousPage) {
            if (previousPage == null) {
                return ListMemoriesIterable.this.client.listMemories(ListMemoriesIterable.this.firstRequest);
            }
            return ListMemoriesIterable.this.client.listMemories((ListMemoriesRequest)((Object)ListMemoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

