/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentRuntimeArtifact;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AuthorizerConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EnvironmentVariablesMapCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.LifecycleConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NetworkConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ProtocolConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RequestHeaderConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgentRuntimeRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, UpdateAgentRuntimeRequest> {
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeId").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::agentRuntimeId)).setter(UpdateAgentRuntimeRequest.setter(Builder::agentRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeId").build()}).build();
    private static final SdkField<AgentRuntimeArtifact> AGENT_RUNTIME_ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentRuntimeArtifact").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::agentRuntimeArtifact)).setter(UpdateAgentRuntimeRequest.setter(Builder::agentRuntimeArtifact)).constructor(AgentRuntimeArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArtifact").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::roleArn)).setter(UpdateAgentRuntimeRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::networkConfiguration)).setter(UpdateAgentRuntimeRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::description)).setter(UpdateAgentRuntimeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizerConfiguration").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::authorizerConfiguration)).setter(UpdateAgentRuntimeRequest.setter(Builder::authorizerConfiguration)).constructor(AuthorizerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build()}).build();
    private static final SdkField<RequestHeaderConfiguration> REQUEST_HEADER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("requestHeaderConfiguration").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::requestHeaderConfiguration)).setter(UpdateAgentRuntimeRequest.setter(Builder::requestHeaderConfiguration)).constructor(RequestHeaderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestHeaderConfiguration").build()}).build();
    private static final SdkField<ProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("protocolConfiguration").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::protocolConfiguration)).setter(UpdateAgentRuntimeRequest.setter(Builder::protocolConfiguration)).constructor(ProtocolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build()}).build();
    private static final SdkField<LifecycleConfiguration> LIFECYCLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifecycleConfiguration").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::lifecycleConfiguration)).setter(UpdateAgentRuntimeRequest.setter(Builder::lifecycleConfiguration)).constructor(LifecycleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::environmentVariables)).setter(UpdateAgentRuntimeRequest.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::clientToken)).setter(UpdateAgentRuntimeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ID_FIELD, AGENT_RUNTIME_ARTIFACT_FIELD, ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, DESCRIPTION_FIELD, AUTHORIZER_CONFIGURATION_FIELD, REQUEST_HEADER_CONFIGURATION_FIELD, PROTOCOL_CONFIGURATION_FIELD, LIFECYCLE_CONFIGURATION_FIELD, ENVIRONMENT_VARIABLES_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAgentRuntimeRequest.memberNameToFieldInitializer();
    private final String agentRuntimeId;
    private final AgentRuntimeArtifact agentRuntimeArtifact;
    private final String roleArn;
    private final NetworkConfiguration networkConfiguration;
    private final String description;
    private final AuthorizerConfiguration authorizerConfiguration;
    private final RequestHeaderConfiguration requestHeaderConfiguration;
    private final ProtocolConfiguration protocolConfiguration;
    private final LifecycleConfiguration lifecycleConfiguration;
    private final Map<String, String> environmentVariables;
    private final String clientToken;

    private UpdateAgentRuntimeRequest(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeId = builder.agentRuntimeId;
        this.agentRuntimeArtifact = builder.agentRuntimeArtifact;
        this.roleArn = builder.roleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.description = builder.description;
        this.authorizerConfiguration = builder.authorizerConfiguration;
        this.requestHeaderConfiguration = builder.requestHeaderConfiguration;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
        this.environmentVariables = builder.environmentVariables;
        this.clientToken = builder.clientToken;
    }

    public final String agentRuntimeId() {
        return this.agentRuntimeId;
    }

    public final AgentRuntimeArtifact agentRuntimeArtifact() {
        return this.agentRuntimeArtifact;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final AuthorizerConfiguration authorizerConfiguration() {
        return this.authorizerConfiguration;
    }

    public final RequestHeaderConfiguration requestHeaderConfiguration() {
        return this.requestHeaderConfiguration;
    }

    public final ProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public final LifecycleConfiguration lifecycleConfiguration() {
        return this.lifecycleConfiguration;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestHeaderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentRuntimeRequest)) {
            return false;
        }
        UpdateAgentRuntimeRequest other = (UpdateAgentRuntimeRequest)((Object)obj);
        return Objects.equals(this.agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(this.agentRuntimeArtifact(), other.agentRuntimeArtifact()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.authorizerConfiguration(), other.authorizerConfiguration()) && Objects.equals(this.requestHeaderConfiguration(), other.requestHeaderConfiguration()) && Objects.equals(this.protocolConfiguration(), other.protocolConfiguration()) && Objects.equals(this.lifecycleConfiguration(), other.lifecycleConfiguration()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgentRuntimeRequest").add("AgentRuntimeId", (Object)this.agentRuntimeId()).add("AgentRuntimeArtifact", (Object)this.agentRuntimeArtifact()).add("RoleArn", (Object)this.roleArn()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthorizerConfiguration", (Object)this.authorizerConfiguration()).add("RequestHeaderConfiguration", (Object)this.requestHeaderConfiguration()).add("ProtocolConfiguration", (Object)this.protocolConfiguration()).add("LifecycleConfiguration", (Object)this.lifecycleConfiguration()).add("EnvironmentVariables", (Object)(this.environmentVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeId()));
            }
            case "agentRuntimeArtifact": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArtifact()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "authorizerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfiguration()));
            }
            case "requestHeaderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.requestHeaderConfiguration()));
            }
            case "protocolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.protocolConfiguration()));
            }
            case "lifecycleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfiguration()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("agentRuntimeArtifact", AGENT_RUNTIME_ARTIFACT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        map.put("requestHeaderConfiguration", REQUEST_HEADER_CONFIGURATION_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("lifecycleConfiguration", LIFECYCLE_CONFIGURATION_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentRuntimeRequest, T> g) {
        return obj -> g.apply((UpdateAgentRuntimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String agentRuntimeId;
        private AgentRuntimeArtifact agentRuntimeArtifact;
        private String roleArn;
        private NetworkConfiguration networkConfiguration;
        private String description;
        private AuthorizerConfiguration authorizerConfiguration;
        private RequestHeaderConfiguration requestHeaderConfiguration;
        private ProtocolConfiguration protocolConfiguration;
        private LifecycleConfiguration lifecycleConfiguration;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentRuntimeRequest model) {
            super(model);
            this.agentRuntimeId(model.agentRuntimeId);
            this.agentRuntimeArtifact(model.agentRuntimeArtifact);
            this.roleArn(model.roleArn);
            this.networkConfiguration(model.networkConfiguration);
            this.description(model.description);
            this.authorizerConfiguration(model.authorizerConfiguration);
            this.requestHeaderConfiguration(model.requestHeaderConfiguration);
            this.protocolConfiguration(model.protocolConfiguration);
            this.lifecycleConfiguration(model.lifecycleConfiguration);
            this.environmentVariables(model.environmentVariables);
            this.clientToken(model.clientToken);
        }

        public final String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final AgentRuntimeArtifact.Builder getAgentRuntimeArtifact() {
            return this.agentRuntimeArtifact != null ? this.agentRuntimeArtifact.toBuilder() : null;
        }

        public final void setAgentRuntimeArtifact(AgentRuntimeArtifact.BuilderImpl agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact != null ? agentRuntimeArtifact.build() : null;
        }

        @Override
        public final Builder agentRuntimeArtifact(AgentRuntimeArtifact agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return this.authorizerConfiguration != null ? this.authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        public final RequestHeaderConfiguration.Builder getRequestHeaderConfiguration() {
            return this.requestHeaderConfiguration != null ? this.requestHeaderConfiguration.toBuilder() : null;
        }

        public final void setRequestHeaderConfiguration(RequestHeaderConfiguration.BuilderImpl requestHeaderConfiguration) {
            this.requestHeaderConfiguration = requestHeaderConfiguration != null ? requestHeaderConfiguration.build() : null;
        }

        @Override
        public final Builder requestHeaderConfiguration(RequestHeaderConfiguration requestHeaderConfiguration) {
            this.requestHeaderConfiguration = requestHeaderConfiguration;
            return this;
        }

        public final ProtocolConfiguration.Builder getProtocolConfiguration() {
            return this.protocolConfiguration != null ? this.protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(ProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(ProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final LifecycleConfiguration.Builder getLifecycleConfiguration() {
            return this.lifecycleConfiguration != null ? this.lifecycleConfiguration.toBuilder() : null;
        }

        public final void setLifecycleConfiguration(LifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(LifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentRuntimeRequest build() {
            return new UpdateAgentRuntimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgentRuntimeRequest> {
        public Builder agentRuntimeId(String var1);

        public Builder agentRuntimeArtifact(AgentRuntimeArtifact var1);

        default public Builder agentRuntimeArtifact(Consumer<AgentRuntimeArtifact.Builder> agentRuntimeArtifact) {
            return this.agentRuntimeArtifact((AgentRuntimeArtifact)((AgentRuntimeArtifact.Builder)AgentRuntimeArtifact.builder().applyMutation(agentRuntimeArtifact)).build());
        }

        public Builder roleArn(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder authorizerConfiguration(AuthorizerConfiguration var1);

        default public Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return this.authorizerConfiguration((AuthorizerConfiguration)((AuthorizerConfiguration.Builder)AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration)).build());
        }

        public Builder requestHeaderConfiguration(RequestHeaderConfiguration var1);

        default public Builder requestHeaderConfiguration(Consumer<RequestHeaderConfiguration.Builder> requestHeaderConfiguration) {
            return this.requestHeaderConfiguration((RequestHeaderConfiguration)((RequestHeaderConfiguration.Builder)RequestHeaderConfiguration.builder().applyMutation(requestHeaderConfiguration)).build());
        }

        public Builder protocolConfiguration(ProtocolConfiguration var1);

        default public Builder protocolConfiguration(Consumer<ProtocolConfiguration.Builder> protocolConfiguration) {
            return this.protocolConfiguration((ProtocolConfiguration)((ProtocolConfiguration.Builder)ProtocolConfiguration.builder().applyMutation(protocolConfiguration)).build());
        }

        public Builder lifecycleConfiguration(LifecycleConfiguration var1);

        default public Builder lifecycleConfiguration(Consumer<LifecycleConfiguration.Builder> lifecycleConfiguration) {
            return this.lifecycleConfiguration((LifecycleConfiguration)((LifecycleConfiguration.Builder)LifecycleConfiguration.builder().applyMutation(lifecycleConfiguration)).build());
        }

        public Builder environmentVariables(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

