/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfigurationsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGatewayTargetRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, CreateGatewayTargetRequest> {
    private static final SdkField<String> GATEWAY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayIdentifier").getter(CreateGatewayTargetRequest.getter(CreateGatewayTargetRequest::gatewayIdentifier)).setter(CreateGatewayTargetRequest.setter(Builder::gatewayIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateGatewayTargetRequest.getter(CreateGatewayTargetRequest::name)).setter(CreateGatewayTargetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateGatewayTargetRequest.getter(CreateGatewayTargetRequest::description)).setter(CreateGatewayTargetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateGatewayTargetRequest.getter(CreateGatewayTargetRequest::clientToken)).setter(CreateGatewayTargetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetConfiguration").getter(CreateGatewayTargetRequest.getter(CreateGatewayTargetRequest::targetConfiguration)).setter(CreateGatewayTargetRequest.setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetConfiguration").build()}).build();
    private static final SdkField<List<CredentialProviderConfiguration>> CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("credentialProviderConfigurations").getter(CreateGatewayTargetRequest.getter(CreateGatewayTargetRequest::credentialProviderConfigurations)).setter(CreateGatewayTargetRequest.setter(Builder::credentialProviderConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CredentialProviderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_IDENTIFIER_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, TARGET_CONFIGURATION_FIELD, CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGatewayTargetRequest.memberNameToFieldInitializer();
    private final String gatewayIdentifier;
    private final String name;
    private final String description;
    private final String clientToken;
    private final TargetConfiguration targetConfiguration;
    private final List<CredentialProviderConfiguration> credentialProviderConfigurations;

    private CreateGatewayTargetRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayIdentifier = builder.gatewayIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.targetConfiguration = builder.targetConfiguration;
        this.credentialProviderConfigurations = builder.credentialProviderConfigurations;
    }

    public final String gatewayIdentifier() {
        return this.gatewayIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public final boolean hasCredentialProviderConfigurations() {
        return this.credentialProviderConfigurations != null && !(this.credentialProviderConfigurations instanceof SdkAutoConstructList);
    }

    public final List<CredentialProviderConfiguration> credentialProviderConfigurations() {
        return this.credentialProviderConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentialProviderConfigurations() ? this.credentialProviderConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayTargetRequest)) {
            return false;
        }
        CreateGatewayTargetRequest other = (CreateGatewayTargetRequest)((Object)obj);
        return Objects.equals(this.gatewayIdentifier(), other.gatewayIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration()) && this.hasCredentialProviderConfigurations() == other.hasCredentialProviderConfigurations() && Objects.equals(this.credentialProviderConfigurations(), other.credentialProviderConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGatewayTargetRequest").add("GatewayIdentifier", (Object)this.gatewayIdentifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("TargetConfiguration", (Object)this.targetConfiguration()).add("CredentialProviderConfigurations", this.hasCredentialProviderConfigurations() ? this.credentialProviderConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayIdentifier": {
                return Optional.ofNullable(clazz.cast(this.gatewayIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "targetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
            case "credentialProviderConfigurations": {
                return Optional.ofNullable(clazz.cast(this.credentialProviderConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayIdentifier", GATEWAY_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("targetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("credentialProviderConfigurations", CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayTargetRequest, T> g) {
        return obj -> g.apply((CreateGatewayTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String gatewayIdentifier;
        private String name;
        private String description;
        private String clientToken;
        private TargetConfiguration targetConfiguration;
        private List<CredentialProviderConfiguration> credentialProviderConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayTargetRequest model) {
            super(model);
            this.gatewayIdentifier(model.gatewayIdentifier);
            this.name(model.name);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.targetConfiguration(model.targetConfiguration);
            this.credentialProviderConfigurations(model.credentialProviderConfigurations);
        }

        public final String getGatewayIdentifier() {
            return this.gatewayIdentifier;
        }

        public final void setGatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
        }

        @Override
        public final Builder gatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final List<CredentialProviderConfiguration.Builder> getCredentialProviderConfigurations() {
            List<CredentialProviderConfiguration.Builder> result = CredentialProviderConfigurationsCopier.copyToBuilder(this.credentialProviderConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialProviderConfigurations(Collection<CredentialProviderConfiguration.BuilderImpl> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = CredentialProviderConfigurationsCopier.copyFromBuilder(credentialProviderConfigurations);
        }

        @Override
        public final Builder credentialProviderConfigurations(Collection<CredentialProviderConfiguration> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = CredentialProviderConfigurationsCopier.copy(credentialProviderConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviderConfigurations(CredentialProviderConfiguration ... credentialProviderConfigurations) {
            this.credentialProviderConfigurations(Arrays.asList(credentialProviderConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviderConfigurations(Consumer<CredentialProviderConfiguration.Builder> ... credentialProviderConfigurations) {
            this.credentialProviderConfigurations(Stream.of(credentialProviderConfigurations).map(c -> (CredentialProviderConfiguration)((CredentialProviderConfiguration.Builder)CredentialProviderConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayTargetRequest build() {
            return new CreateGatewayTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGatewayTargetRequest> {
        public Builder gatewayIdentifier(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder targetConfiguration(TargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((TargetConfiguration)((TargetConfiguration.Builder)TargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder credentialProviderConfigurations(Collection<CredentialProviderConfiguration> var1);

        public Builder credentialProviderConfigurations(CredentialProviderConfiguration ... var1);

        public Builder credentialProviderConfigurations(Consumer<CredentialProviderConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

