/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AllowedAudienceListCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AllowedClientsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomJWTAuthorizerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomJWTAuthorizerConfiguration> {
    private static final SdkField<String> DISCOVERY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("discoveryUrl").getter(CustomJWTAuthorizerConfiguration.getter(CustomJWTAuthorizerConfiguration::discoveryUrl)).setter(CustomJWTAuthorizerConfiguration.setter(Builder::discoveryUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryUrl").build()}).build();
    private static final SdkField<List<String>> ALLOWED_AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedAudience").getter(CustomJWTAuthorizerConfiguration.getter(CustomJWTAuthorizerConfiguration::allowedAudience)).setter(CustomJWTAuthorizerConfiguration.setter(Builder::allowedAudience)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAudience").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_CLIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedClients").getter(CustomJWTAuthorizerConfiguration.getter(CustomJWTAuthorizerConfiguration::allowedClients)).setter(CustomJWTAuthorizerConfiguration.setter(Builder::allowedClients)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedClients").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_URL_FIELD, ALLOWED_AUDIENCE_FIELD, ALLOWED_CLIENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomJWTAuthorizerConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String discoveryUrl;
    private final List<String> allowedAudience;
    private final List<String> allowedClients;

    private CustomJWTAuthorizerConfiguration(BuilderImpl builder) {
        this.discoveryUrl = builder.discoveryUrl;
        this.allowedAudience = builder.allowedAudience;
        this.allowedClients = builder.allowedClients;
    }

    public final String discoveryUrl() {
        return this.discoveryUrl;
    }

    public final boolean hasAllowedAudience() {
        return this.allowedAudience != null && !(this.allowedAudience instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAudience() {
        return this.allowedAudience;
    }

    public final boolean hasAllowedClients() {
        return this.allowedClients != null && !(this.allowedClients instanceof SdkAutoConstructList);
    }

    public final List<String> allowedClients() {
        return this.allowedClients;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAudience() ? this.allowedAudience() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedClients() ? this.allowedClients() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomJWTAuthorizerConfiguration)) {
            return false;
        }
        CustomJWTAuthorizerConfiguration other = (CustomJWTAuthorizerConfiguration)obj;
        return Objects.equals(this.discoveryUrl(), other.discoveryUrl()) && this.hasAllowedAudience() == other.hasAllowedAudience() && Objects.equals(this.allowedAudience(), other.allowedAudience()) && this.hasAllowedClients() == other.hasAllowedClients() && Objects.equals(this.allowedClients(), other.allowedClients());
    }

    public final String toString() {
        return ToString.builder((String)"CustomJWTAuthorizerConfiguration").add("DiscoveryUrl", (Object)this.discoveryUrl()).add("AllowedAudience", this.hasAllowedAudience() ? this.allowedAudience() : null).add("AllowedClients", this.hasAllowedClients() ? this.allowedClients() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "discoveryUrl": {
                return Optional.ofNullable(clazz.cast(this.discoveryUrl()));
            }
            case "allowedAudience": {
                return Optional.ofNullable(clazz.cast(this.allowedAudience()));
            }
            case "allowedClients": {
                return Optional.ofNullable(clazz.cast(this.allowedClients()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("discoveryUrl", DISCOVERY_URL_FIELD);
        map.put("allowedAudience", ALLOWED_AUDIENCE_FIELD);
        map.put("allowedClients", ALLOWED_CLIENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomJWTAuthorizerConfiguration, T> g) {
        return obj -> g.apply((CustomJWTAuthorizerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String discoveryUrl;
        private List<String> allowedAudience = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedClients = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomJWTAuthorizerConfiguration model) {
            this.discoveryUrl(model.discoveryUrl);
            this.allowedAudience(model.allowedAudience);
            this.allowedClients(model.allowedClients);
        }

        public final String getDiscoveryUrl() {
            return this.discoveryUrl;
        }

        public final void setDiscoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
        }

        @Override
        public final Builder discoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
            return this;
        }

        public final Collection<String> getAllowedAudience() {
            if (this.allowedAudience instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAudience;
        }

        public final void setAllowedAudience(Collection<String> allowedAudience) {
            this.allowedAudience = AllowedAudienceListCopier.copy(allowedAudience);
        }

        @Override
        public final Builder allowedAudience(Collection<String> allowedAudience) {
            this.allowedAudience = AllowedAudienceListCopier.copy(allowedAudience);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAudience(String ... allowedAudience) {
            this.allowedAudience(Arrays.asList(allowedAudience));
            return this;
        }

        public final Collection<String> getAllowedClients() {
            if (this.allowedClients instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedClients;
        }

        public final void setAllowedClients(Collection<String> allowedClients) {
            this.allowedClients = AllowedClientsListCopier.copy(allowedClients);
        }

        @Override
        public final Builder allowedClients(Collection<String> allowedClients) {
            this.allowedClients = AllowedClientsListCopier.copy(allowedClients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedClients(String ... allowedClients) {
            this.allowedClients(Arrays.asList(allowedClients));
            return this;
        }

        public CustomJWTAuthorizerConfiguration build() {
            return new CustomJWTAuthorizerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomJWTAuthorizerConfiguration> {
        public Builder discoveryUrl(String var1);

        public Builder allowedAudience(Collection<String> var1);

        public Builder allowedAudience(String ... var1);

        public Builder allowedClients(Collection<String> var1);

        public Builder allowedClients(String ... var1);
    }
}

