/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentRuntimeEndpointStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAgentRuntimeEndpointResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, CreateAgentRuntimeEndpointResponse> {
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetVersion").getter(CreateAgentRuntimeEndpointResponse.getter(CreateAgentRuntimeEndpointResponse::targetVersion)).setter(CreateAgentRuntimeEndpointResponse.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersion").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeEndpointArn").getter(CreateAgentRuntimeEndpointResponse.getter(CreateAgentRuntimeEndpointResponse::agentRuntimeEndpointArn)).setter(CreateAgentRuntimeEndpointResponse.setter(Builder::agentRuntimeEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeEndpointArn").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeArn").getter(CreateAgentRuntimeEndpointResponse.getter(CreateAgentRuntimeEndpointResponse::agentRuntimeArn)).setter(CreateAgentRuntimeEndpointResponse.setter(Builder::agentRuntimeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeId").getter(CreateAgentRuntimeEndpointResponse.getter(CreateAgentRuntimeEndpointResponse::agentRuntimeId)).setter(CreateAgentRuntimeEndpointResponse.setter(Builder::agentRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeId").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointName").getter(CreateAgentRuntimeEndpointResponse.getter(CreateAgentRuntimeEndpointResponse::endpointName)).setter(CreateAgentRuntimeEndpointResponse.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateAgentRuntimeEndpointResponse.getter(CreateAgentRuntimeEndpointResponse::statusAsString)).setter(CreateAgentRuntimeEndpointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateAgentRuntimeEndpointResponse.getter(CreateAgentRuntimeEndpointResponse::createdAt)).setter(CreateAgentRuntimeEndpointResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VERSION_FIELD, AGENT_RUNTIME_ENDPOINT_ARN_FIELD, AGENT_RUNTIME_ARN_FIELD, AGENT_RUNTIME_ID_FIELD, ENDPOINT_NAME_FIELD, STATUS_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAgentRuntimeEndpointResponse.memberNameToFieldInitializer();
    private final String targetVersion;
    private final String agentRuntimeEndpointArn;
    private final String agentRuntimeArn;
    private final String agentRuntimeId;
    private final String endpointName;
    private final String status;
    private final Instant createdAt;

    private CreateAgentRuntimeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.targetVersion = builder.targetVersion;
        this.agentRuntimeEndpointArn = builder.agentRuntimeEndpointArn;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.agentRuntimeId = builder.agentRuntimeId;
        this.endpointName = builder.endpointName;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
    }

    public final String targetVersion() {
        return this.targetVersion;
    }

    public final String agentRuntimeEndpointArn() {
        return this.agentRuntimeEndpointArn;
    }

    public final String agentRuntimeArn() {
        return this.agentRuntimeArn;
    }

    public final String agentRuntimeId() {
        return this.agentRuntimeId;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final AgentRuntimeEndpointStatus status() {
        return AgentRuntimeEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRuntimeEndpointResponse)) {
            return false;
        }
        CreateAgentRuntimeEndpointResponse other = (CreateAgentRuntimeEndpointResponse)((Object)obj);
        return Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.agentRuntimeEndpointArn(), other.agentRuntimeEndpointArn()) && Objects.equals(this.agentRuntimeArn(), other.agentRuntimeArn()) && Objects.equals(this.agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAgentRuntimeEndpointResponse").add("TargetVersion", (Object)this.targetVersion()).add("AgentRuntimeEndpointArn", (Object)this.agentRuntimeEndpointArn()).add("AgentRuntimeArn", (Object)this.agentRuntimeArn()).add("AgentRuntimeId", (Object)this.agentRuntimeId()).add("EndpointName", (Object)(this.endpointName() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "agentRuntimeEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeEndpointArn()));
            }
            case "agentRuntimeArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArn()));
            }
            case "agentRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeId()));
            }
            case "endpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetVersion", TARGET_VERSION_FIELD);
        map.put("agentRuntimeEndpointArn", AGENT_RUNTIME_ENDPOINT_ARN_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("endpointName", ENDPOINT_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRuntimeEndpointResponse, T> g) {
        return obj -> g.apply((CreateAgentRuntimeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String targetVersion;
        private String agentRuntimeEndpointArn;
        private String agentRuntimeArn;
        private String agentRuntimeId;
        private String endpointName;
        private String status;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRuntimeEndpointResponse model) {
            super(model);
            this.targetVersion(model.targetVersion);
            this.agentRuntimeEndpointArn(model.agentRuntimeEndpointArn);
            this.agentRuntimeArn(model.agentRuntimeArn);
            this.agentRuntimeId(model.agentRuntimeId);
            this.endpointName(model.endpointName);
            this.status(model.status);
            this.createdAt(model.createdAt);
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final String getAgentRuntimeEndpointArn() {
            return this.agentRuntimeEndpointArn;
        }

        public final void setAgentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
        }

        @Override
        public final Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentRuntimeEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateAgentRuntimeEndpointResponse build() {
            return new CreateAgentRuntimeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAgentRuntimeEndpointResponse> {
        public Builder targetVersion(String var1);

        public Builder agentRuntimeEndpointArn(String var1);

        public Builder agentRuntimeArn(String var1);

        public Builder agentRuntimeId(String var1);

        public Builder endpointName(String var1);

        public Builder status(String var1);

        public Builder status(AgentRuntimeEndpointStatus var1);

        public Builder createdAt(Instant var1);
    }
}

