/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserNetworkConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RecordingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBrowserResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, GetBrowserResponse> {
    private static final SdkField<String> BROWSER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserId").getter(GetBrowserResponse.getter(GetBrowserResponse::browserId)).setter(GetBrowserResponse.setter(Builder::browserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserId").build()}).build();
    private static final SdkField<String> BROWSER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserArn").getter(GetBrowserResponse.getter(GetBrowserResponse::browserArn)).setter(GetBrowserResponse.setter(Builder::browserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetBrowserResponse.getter(GetBrowserResponse::name)).setter(GetBrowserResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetBrowserResponse.getter(GetBrowserResponse::description)).setter(GetBrowserResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(GetBrowserResponse.getter(GetBrowserResponse::executionRoleArn)).setter(GetBrowserResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<BrowserNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(GetBrowserResponse.getter(GetBrowserResponse::networkConfiguration)).setter(GetBrowserResponse.setter(Builder::networkConfiguration)).constructor(BrowserNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<RecordingConfig> RECORDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recording").getter(GetBrowserResponse.getter(GetBrowserResponse::recording)).setter(GetBrowserResponse.setter(Builder::recording)).constructor(RecordingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recording").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetBrowserResponse.getter(GetBrowserResponse::statusAsString)).setter(GetBrowserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(GetBrowserResponse.getter(GetBrowserResponse::failureReason)).setter(GetBrowserResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetBrowserResponse.getter(GetBrowserResponse::createdAt)).setter(GetBrowserResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetBrowserResponse.getter(GetBrowserResponse::lastUpdatedAt)).setter(GetBrowserResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_ID_FIELD, BROWSER_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, EXECUTION_ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, RECORDING_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBrowserResponse.memberNameToFieldInitializer();
    private final String browserId;
    private final String browserArn;
    private final String name;
    private final String description;
    private final String executionRoleArn;
    private final BrowserNetworkConfiguration networkConfiguration;
    private final RecordingConfig recording;
    private final String status;
    private final String failureReason;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private GetBrowserResponse(BuilderImpl builder) {
        super(builder);
        this.browserId = builder.browserId;
        this.browserArn = builder.browserArn;
        this.name = builder.name;
        this.description = builder.description;
        this.executionRoleArn = builder.executionRoleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.recording = builder.recording;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String browserId() {
        return this.browserId;
    }

    public final String browserArn() {
        return this.browserArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final BrowserNetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final RecordingConfig recording() {
        return this.recording;
    }

    public final BrowserStatus status() {
        return BrowserStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.browserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.recording());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBrowserResponse)) {
            return false;
        }
        GetBrowserResponse other = (GetBrowserResponse)((Object)obj);
        return Objects.equals(this.browserId(), other.browserId()) && Objects.equals(this.browserArn(), other.browserArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.recording(), other.recording()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetBrowserResponse").add("BrowserId", (Object)this.browserId()).add("BrowserArn", (Object)this.browserArn()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Recording", (Object)this.recording()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserId": {
                return Optional.ofNullable(clazz.cast(this.browserId()));
            }
            case "browserArn": {
                return Optional.ofNullable(clazz.cast(this.browserArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "recording": {
                return Optional.ofNullable(clazz.cast(this.recording()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("browserId", BROWSER_ID_FIELD);
        map.put("browserArn", BROWSER_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("recording", RECORDING_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBrowserResponse, T> g) {
        return obj -> g.apply((GetBrowserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String browserId;
        private String browserArn;
        private String name;
        private String description;
        private String executionRoleArn;
        private BrowserNetworkConfiguration networkConfiguration;
        private RecordingConfig recording;
        private String status;
        private String failureReason;
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBrowserResponse model) {
            super(model);
            this.browserId(model.browserId);
            this.browserArn(model.browserArn);
            this.name(model.name);
            this.description(model.description);
            this.executionRoleArn(model.executionRoleArn);
            this.networkConfiguration(model.networkConfiguration);
            this.recording(model.recording);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getBrowserId() {
            return this.browserId;
        }

        public final void setBrowserId(String browserId) {
            this.browserId = browserId;
        }

        @Override
        public final Builder browserId(String browserId) {
            this.browserId = browserId;
            return this;
        }

        public final String getBrowserArn() {
            return this.browserArn;
        }

        public final void setBrowserArn(String browserArn) {
            this.browserArn = browserArn;
        }

        @Override
        public final Builder browserArn(String browserArn) {
            this.browserArn = browserArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final BrowserNetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(BrowserNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(BrowserNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final RecordingConfig.Builder getRecording() {
            return this.recording != null ? this.recording.toBuilder() : null;
        }

        public final void setRecording(RecordingConfig.BuilderImpl recording) {
            this.recording = recording != null ? recording.build() : null;
        }

        @Override
        public final Builder recording(RecordingConfig recording) {
            this.recording = recording;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetBrowserResponse build() {
            return new GetBrowserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBrowserResponse> {
        public Builder browserId(String var1);

        public Builder browserArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder executionRoleArn(String var1);

        public Builder networkConfiguration(BrowserNetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<BrowserNetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((BrowserNetworkConfiguration)((BrowserNetworkConfiguration.Builder)BrowserNetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder recording(RecordingConfig var1);

        default public Builder recording(Consumer<RecordingConfig.Builder> recording) {
            return this.recording((RecordingConfig)((RecordingConfig.Builder)RecordingConfig.builder().applyMutation(recording)).build());
        }

        public Builder status(String var1);

        public Builder status(BrowserStatus var1);

        public Builder failureReason(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

