/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CredentialProviderVendorType {
    GOOGLE_OAUTH2("GoogleOauth2"),
    GITHUB_OAUTH2("GithubOauth2"),
    SLACK_OAUTH2("SlackOauth2"),
    SALESFORCE_OAUTH2("SalesforceOauth2"),
    MICROSOFT_OAUTH2("MicrosoftOauth2"),
    CUSTOM_OAUTH2("CustomOauth2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CredentialProviderVendorType> VALUE_MAP;
    private final String value;

    private CredentialProviderVendorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CredentialProviderVendorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CredentialProviderVendorType> knownValues() {
        EnumSet<CredentialProviderVendorType> knownValues = EnumSet.allOf(CredentialProviderVendorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CredentialProviderVendorType.class, CredentialProviderVendorType::toString);
    }
}

