/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderVendorType;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Oauth2ProviderConfigOutput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Secret;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOauth2CredentialProviderResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, UpdateOauth2CredentialProviderResponse> {
    private static final SdkField<Secret> CLIENT_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("clientSecretArn").getter(UpdateOauth2CredentialProviderResponse.getter(UpdateOauth2CredentialProviderResponse::clientSecretArn)).setter(UpdateOauth2CredentialProviderResponse.setter(Builder::clientSecretArn)).constructor(Secret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecretArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateOauth2CredentialProviderResponse.getter(UpdateOauth2CredentialProviderResponse::name)).setter(UpdateOauth2CredentialProviderResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CREDENTIAL_PROVIDER_VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialProviderVendor").getter(UpdateOauth2CredentialProviderResponse.getter(UpdateOauth2CredentialProviderResponse::credentialProviderVendorAsString)).setter(UpdateOauth2CredentialProviderResponse.setter(Builder::credentialProviderVendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderVendor").build()}).build();
    private static final SdkField<String> CREDENTIAL_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialProviderArn").getter(UpdateOauth2CredentialProviderResponse.getter(UpdateOauth2CredentialProviderResponse::credentialProviderArn)).setter(UpdateOauth2CredentialProviderResponse.setter(Builder::credentialProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderArn").build()}).build();
    private static final SdkField<Oauth2ProviderConfigOutput> OAUTH2_PROVIDER_CONFIG_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oauth2ProviderConfigOutput").getter(UpdateOauth2CredentialProviderResponse.getter(UpdateOauth2CredentialProviderResponse::oauth2ProviderConfigOutput)).setter(UpdateOauth2CredentialProviderResponse.setter(Builder::oauth2ProviderConfigOutput)).constructor(Oauth2ProviderConfigOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2ProviderConfigOutput").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(UpdateOauth2CredentialProviderResponse.getter(UpdateOauth2CredentialProviderResponse::createdTime)).setter(UpdateOauth2CredentialProviderResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(UpdateOauth2CredentialProviderResponse.getter(UpdateOauth2CredentialProviderResponse::lastUpdatedTime)).setter(UpdateOauth2CredentialProviderResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_SECRET_ARN_FIELD, NAME_FIELD, CREDENTIAL_PROVIDER_VENDOR_FIELD, CREDENTIAL_PROVIDER_ARN_FIELD, OAUTH2_PROVIDER_CONFIG_OUTPUT_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOauth2CredentialProviderResponse.memberNameToFieldInitializer();
    private final Secret clientSecretArn;
    private final String name;
    private final String credentialProviderVendor;
    private final String credentialProviderArn;
    private final Oauth2ProviderConfigOutput oauth2ProviderConfigOutput;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    private UpdateOauth2CredentialProviderResponse(BuilderImpl builder) {
        super(builder);
        this.clientSecretArn = builder.clientSecretArn;
        this.name = builder.name;
        this.credentialProviderVendor = builder.credentialProviderVendor;
        this.credentialProviderArn = builder.credentialProviderArn;
        this.oauth2ProviderConfigOutput = builder.oauth2ProviderConfigOutput;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final Secret clientSecretArn() {
        return this.clientSecretArn;
    }

    public final String name() {
        return this.name;
    }

    public final CredentialProviderVendorType credentialProviderVendor() {
        return CredentialProviderVendorType.fromValue(this.credentialProviderVendor);
    }

    public final String credentialProviderVendorAsString() {
        return this.credentialProviderVendor;
    }

    public final String credentialProviderArn() {
        return this.credentialProviderArn;
    }

    public final Oauth2ProviderConfigOutput oauth2ProviderConfigOutput() {
        return this.oauth2ProviderConfigOutput;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialProviderVendorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.oauth2ProviderConfigOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOauth2CredentialProviderResponse)) {
            return false;
        }
        UpdateOauth2CredentialProviderResponse other = (UpdateOauth2CredentialProviderResponse)((Object)obj);
        return Objects.equals(this.clientSecretArn(), other.clientSecretArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.credentialProviderVendorAsString(), other.credentialProviderVendorAsString()) && Objects.equals(this.credentialProviderArn(), other.credentialProviderArn()) && Objects.equals(this.oauth2ProviderConfigOutput(), other.oauth2ProviderConfigOutput()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOauth2CredentialProviderResponse").add("ClientSecretArn", (Object)this.clientSecretArn()).add("Name", (Object)this.name()).add("CredentialProviderVendor", (Object)this.credentialProviderVendorAsString()).add("CredentialProviderArn", (Object)this.credentialProviderArn()).add("Oauth2ProviderConfigOutput", (Object)this.oauth2ProviderConfigOutput()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientSecretArn": {
                return Optional.ofNullable(clazz.cast(this.clientSecretArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "credentialProviderVendor": {
                return Optional.ofNullable(clazz.cast(this.credentialProviderVendorAsString()));
            }
            case "credentialProviderArn": {
                return Optional.ofNullable(clazz.cast(this.credentialProviderArn()));
            }
            case "oauth2ProviderConfigOutput": {
                return Optional.ofNullable(clazz.cast(this.oauth2ProviderConfigOutput()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientSecretArn", CLIENT_SECRET_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("credentialProviderVendor", CREDENTIAL_PROVIDER_VENDOR_FIELD);
        map.put("credentialProviderArn", CREDENTIAL_PROVIDER_ARN_FIELD);
        map.put("oauth2ProviderConfigOutput", OAUTH2_PROVIDER_CONFIG_OUTPUT_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOauth2CredentialProviderResponse, T> g) {
        return obj -> g.apply((UpdateOauth2CredentialProviderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private Secret clientSecretArn;
        private String name;
        private String credentialProviderVendor;
        private String credentialProviderArn;
        private Oauth2ProviderConfigOutput oauth2ProviderConfigOutput;
        private Instant createdTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOauth2CredentialProviderResponse model) {
            super(model);
            this.clientSecretArn(model.clientSecretArn);
            this.name(model.name);
            this.credentialProviderVendor(model.credentialProviderVendor);
            this.credentialProviderArn(model.credentialProviderArn);
            this.oauth2ProviderConfigOutput(model.oauth2ProviderConfigOutput);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final Secret.Builder getClientSecretArn() {
            return this.clientSecretArn != null ? this.clientSecretArn.toBuilder() : null;
        }

        public final void setClientSecretArn(Secret.BuilderImpl clientSecretArn) {
            this.clientSecretArn = clientSecretArn != null ? clientSecretArn.build() : null;
        }

        @Override
        public final Builder clientSecretArn(Secret clientSecretArn) {
            this.clientSecretArn = clientSecretArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCredentialProviderVendor() {
            return this.credentialProviderVendor;
        }

        public final void setCredentialProviderVendor(String credentialProviderVendor) {
            this.credentialProviderVendor = credentialProviderVendor;
        }

        @Override
        public final Builder credentialProviderVendor(String credentialProviderVendor) {
            this.credentialProviderVendor = credentialProviderVendor;
            return this;
        }

        @Override
        public final Builder credentialProviderVendor(CredentialProviderVendorType credentialProviderVendor) {
            this.credentialProviderVendor(credentialProviderVendor == null ? null : credentialProviderVendor.toString());
            return this;
        }

        public final String getCredentialProviderArn() {
            return this.credentialProviderArn;
        }

        public final void setCredentialProviderArn(String credentialProviderArn) {
            this.credentialProviderArn = credentialProviderArn;
        }

        @Override
        public final Builder credentialProviderArn(String credentialProviderArn) {
            this.credentialProviderArn = credentialProviderArn;
            return this;
        }

        public final Oauth2ProviderConfigOutput.Builder getOauth2ProviderConfigOutput() {
            return this.oauth2ProviderConfigOutput != null ? this.oauth2ProviderConfigOutput.toBuilder() : null;
        }

        public final void setOauth2ProviderConfigOutput(Oauth2ProviderConfigOutput.BuilderImpl oauth2ProviderConfigOutput) {
            this.oauth2ProviderConfigOutput = oauth2ProviderConfigOutput != null ? oauth2ProviderConfigOutput.build() : null;
        }

        @Override
        public final Builder oauth2ProviderConfigOutput(Oauth2ProviderConfigOutput oauth2ProviderConfigOutput) {
            this.oauth2ProviderConfigOutput = oauth2ProviderConfigOutput;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public UpdateOauth2CredentialProviderResponse build() {
            return new UpdateOauth2CredentialProviderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOauth2CredentialProviderResponse> {
        public Builder clientSecretArn(Secret var1);

        default public Builder clientSecretArn(Consumer<Secret.Builder> clientSecretArn) {
            return this.clientSecretArn((Secret)((Secret.Builder)Secret.builder().applyMutation(clientSecretArn)).build());
        }

        public Builder name(String var1);

        public Builder credentialProviderVendor(String var1);

        public Builder credentialProviderVendor(CredentialProviderVendorType var1);

        public Builder credentialProviderArn(String var1);

        public Builder oauth2ProviderConfigOutput(Oauth2ProviderConfigOutput var1);

        default public Builder oauth2ProviderConfigOutput(Consumer<Oauth2ProviderConfigOutput.Builder> oauth2ProviderConfigOutput) {
            return this.oauth2ProviderConfigOutput((Oauth2ProviderConfigOutput)((Oauth2ProviderConfigOutput.Builder)Oauth2ProviderConfigOutput.builder().applyMutation(oauth2ProviderConfigOutput)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

