/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SemanticExtractionOverride;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UserPreferenceExtractionOverride;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomExtractionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomExtractionConfiguration> {
    private static final SdkField<SemanticExtractionOverride> SEMANTIC_EXTRACTION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("semanticExtractionOverride").getter(CustomExtractionConfiguration.getter(CustomExtractionConfiguration::semanticExtractionOverride)).setter(CustomExtractionConfiguration.setter(Builder::semanticExtractionOverride)).constructor(SemanticExtractionOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticExtractionOverride").build()}).build();
    private static final SdkField<UserPreferenceExtractionOverride> USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userPreferenceExtractionOverride").getter(CustomExtractionConfiguration.getter(CustomExtractionConfiguration::userPreferenceExtractionOverride)).setter(CustomExtractionConfiguration.setter(Builder::userPreferenceExtractionOverride)).constructor(UserPreferenceExtractionOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPreferenceExtractionOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEMANTIC_EXTRACTION_OVERRIDE_FIELD, USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomExtractionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SemanticExtractionOverride semanticExtractionOverride;
    private final UserPreferenceExtractionOverride userPreferenceExtractionOverride;
    private final Type type;

    private CustomExtractionConfiguration(BuilderImpl builder) {
        this.semanticExtractionOverride = builder.semanticExtractionOverride;
        this.userPreferenceExtractionOverride = builder.userPreferenceExtractionOverride;
        this.type = builder.type;
    }

    public final SemanticExtractionOverride semanticExtractionOverride() {
        return this.semanticExtractionOverride;
    }

    public final UserPreferenceExtractionOverride userPreferenceExtractionOverride() {
        return this.userPreferenceExtractionOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticExtractionOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPreferenceExtractionOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomExtractionConfiguration)) {
            return false;
        }
        CustomExtractionConfiguration other = (CustomExtractionConfiguration)obj;
        return Objects.equals(this.semanticExtractionOverride(), other.semanticExtractionOverride()) && Objects.equals(this.userPreferenceExtractionOverride(), other.userPreferenceExtractionOverride());
    }

    public final String toString() {
        return ToString.builder((String)"CustomExtractionConfiguration").add("SemanticExtractionOverride", (Object)this.semanticExtractionOverride()).add("UserPreferenceExtractionOverride", (Object)this.userPreferenceExtractionOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "semanticExtractionOverride": {
                return Optional.ofNullable(clazz.cast(this.semanticExtractionOverride()));
            }
            case "userPreferenceExtractionOverride": {
                return Optional.ofNullable(clazz.cast(this.userPreferenceExtractionOverride()));
            }
        }
        return Optional.empty();
    }

    public static CustomExtractionConfiguration fromSemanticExtractionOverride(SemanticExtractionOverride semanticExtractionOverride) {
        return (CustomExtractionConfiguration)CustomExtractionConfiguration.builder().semanticExtractionOverride(semanticExtractionOverride).build();
    }

    public static CustomExtractionConfiguration fromSemanticExtractionOverride(Consumer<SemanticExtractionOverride.Builder> semanticExtractionOverride) {
        SemanticExtractionOverride.Builder builder = SemanticExtractionOverride.builder();
        semanticExtractionOverride.accept(builder);
        return CustomExtractionConfiguration.fromSemanticExtractionOverride((SemanticExtractionOverride)builder.build());
    }

    public static CustomExtractionConfiguration fromUserPreferenceExtractionOverride(UserPreferenceExtractionOverride userPreferenceExtractionOverride) {
        return (CustomExtractionConfiguration)CustomExtractionConfiguration.builder().userPreferenceExtractionOverride(userPreferenceExtractionOverride).build();
    }

    public static CustomExtractionConfiguration fromUserPreferenceExtractionOverride(Consumer<UserPreferenceExtractionOverride.Builder> userPreferenceExtractionOverride) {
        UserPreferenceExtractionOverride.Builder builder = UserPreferenceExtractionOverride.builder();
        userPreferenceExtractionOverride.accept(builder);
        return CustomExtractionConfiguration.fromUserPreferenceExtractionOverride((UserPreferenceExtractionOverride)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("semanticExtractionOverride", SEMANTIC_EXTRACTION_OVERRIDE_FIELD);
        map.put("userPreferenceExtractionOverride", USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomExtractionConfiguration, T> g) {
        return obj -> g.apply((CustomExtractionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SEMANTIC_EXTRACTION_OVERRIDE,
        USER_PREFERENCE_EXTRACTION_OVERRIDE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SemanticExtractionOverride semanticExtractionOverride;
        private UserPreferenceExtractionOverride userPreferenceExtractionOverride;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomExtractionConfiguration model) {
            this.semanticExtractionOverride(model.semanticExtractionOverride);
            this.userPreferenceExtractionOverride(model.userPreferenceExtractionOverride);
        }

        public final SemanticExtractionOverride.Builder getSemanticExtractionOverride() {
            return this.semanticExtractionOverride != null ? this.semanticExtractionOverride.toBuilder() : null;
        }

        public final void setSemanticExtractionOverride(SemanticExtractionOverride.BuilderImpl semanticExtractionOverride) {
            SemanticExtractionOverride oldValue = this.semanticExtractionOverride;
            this.semanticExtractionOverride = semanticExtractionOverride != null ? semanticExtractionOverride.build() : null;
            this.handleUnionValueChange(Type.SEMANTIC_EXTRACTION_OVERRIDE, oldValue, this.semanticExtractionOverride);
        }

        @Override
        public final Builder semanticExtractionOverride(SemanticExtractionOverride semanticExtractionOverride) {
            SemanticExtractionOverride oldValue = this.semanticExtractionOverride;
            this.semanticExtractionOverride = semanticExtractionOverride;
            this.handleUnionValueChange(Type.SEMANTIC_EXTRACTION_OVERRIDE, oldValue, this.semanticExtractionOverride);
            return this;
        }

        public final UserPreferenceExtractionOverride.Builder getUserPreferenceExtractionOverride() {
            return this.userPreferenceExtractionOverride != null ? this.userPreferenceExtractionOverride.toBuilder() : null;
        }

        public final void setUserPreferenceExtractionOverride(UserPreferenceExtractionOverride.BuilderImpl userPreferenceExtractionOverride) {
            UserPreferenceExtractionOverride oldValue = this.userPreferenceExtractionOverride;
            this.userPreferenceExtractionOverride = userPreferenceExtractionOverride != null ? userPreferenceExtractionOverride.build() : null;
            this.handleUnionValueChange(Type.USER_PREFERENCE_EXTRACTION_OVERRIDE, oldValue, this.userPreferenceExtractionOverride);
        }

        @Override
        public final Builder userPreferenceExtractionOverride(UserPreferenceExtractionOverride userPreferenceExtractionOverride) {
            UserPreferenceExtractionOverride oldValue = this.userPreferenceExtractionOverride;
            this.userPreferenceExtractionOverride = userPreferenceExtractionOverride;
            this.handleUnionValueChange(Type.USER_PREFERENCE_EXTRACTION_OVERRIDE, oldValue, this.userPreferenceExtractionOverride);
            return this;
        }

        public CustomExtractionConfiguration build() {
            return new CustomExtractionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomExtractionConfiguration> {
        public Builder semanticExtractionOverride(SemanticExtractionOverride var1);

        default public Builder semanticExtractionOverride(Consumer<SemanticExtractionOverride.Builder> semanticExtractionOverride) {
            return this.semanticExtractionOverride((SemanticExtractionOverride)((SemanticExtractionOverride.Builder)SemanticExtractionOverride.builder().applyMutation(semanticExtractionOverride)).build());
        }

        public Builder userPreferenceExtractionOverride(UserPreferenceExtractionOverride var1);

        default public Builder userPreferenceExtractionOverride(Consumer<UserPreferenceExtractionOverride.Builder> userPreferenceExtractionOverride) {
            return this.userPreferenceExtractionOverride((UserPreferenceExtractionOverride)((UserPreferenceExtractionOverride.Builder)UserPreferenceExtractionOverride.builder().applyMutation(userPreferenceExtractionOverride)).build());
        }
    }
}

