/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentRuntimeArtifact;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AuthorizerConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EnvironmentVariablesMapCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NetworkConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ProtocolConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RequestHeaderConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAgentRuntimeRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, CreateAgentRuntimeRequest> {
    private static final SdkField<String> AGENT_RUNTIME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeName").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::agentRuntimeName)).setter(CreateAgentRuntimeRequest.setter(Builder::agentRuntimeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::description)).setter(CreateAgentRuntimeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AgentRuntimeArtifact> AGENT_RUNTIME_ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentRuntimeArtifact").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::agentRuntimeArtifact)).setter(CreateAgentRuntimeRequest.setter(Builder::agentRuntimeArtifact)).constructor(AgentRuntimeArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArtifact").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::roleArn)).setter(CreateAgentRuntimeRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::networkConfiguration)).setter(CreateAgentRuntimeRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<ProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("protocolConfiguration").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::protocolConfiguration)).setter(CreateAgentRuntimeRequest.setter(Builder::protocolConfiguration)).constructor(ProtocolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::clientToken)).setter(CreateAgentRuntimeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::environmentVariables)).setter(CreateAgentRuntimeRequest.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizerConfiguration").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::authorizerConfiguration)).setter(CreateAgentRuntimeRequest.setter(Builder::authorizerConfiguration)).constructor(AuthorizerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build()}).build();
    private static final SdkField<RequestHeaderConfiguration> REQUEST_HEADER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("requestHeaderConfiguration").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::requestHeaderConfiguration)).setter(CreateAgentRuntimeRequest.setter(Builder::requestHeaderConfiguration)).constructor(RequestHeaderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestHeaderConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAgentRuntimeRequest.getter(CreateAgentRuntimeRequest::tags)).setter(CreateAgentRuntimeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_NAME_FIELD, DESCRIPTION_FIELD, AGENT_RUNTIME_ARTIFACT_FIELD, ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, PROTOCOL_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, ENVIRONMENT_VARIABLES_FIELD, AUTHORIZER_CONFIGURATION_FIELD, REQUEST_HEADER_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAgentRuntimeRequest.memberNameToFieldInitializer();
    private final String agentRuntimeName;
    private final String description;
    private final AgentRuntimeArtifact agentRuntimeArtifact;
    private final String roleArn;
    private final NetworkConfiguration networkConfiguration;
    private final ProtocolConfiguration protocolConfiguration;
    private final String clientToken;
    private final Map<String, String> environmentVariables;
    private final AuthorizerConfiguration authorizerConfiguration;
    private final RequestHeaderConfiguration requestHeaderConfiguration;
    private final Map<String, String> tags;

    private CreateAgentRuntimeRequest(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeName = builder.agentRuntimeName;
        this.description = builder.description;
        this.agentRuntimeArtifact = builder.agentRuntimeArtifact;
        this.roleArn = builder.roleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.clientToken = builder.clientToken;
        this.environmentVariables = builder.environmentVariables;
        this.authorizerConfiguration = builder.authorizerConfiguration;
        this.requestHeaderConfiguration = builder.requestHeaderConfiguration;
        this.tags = builder.tags;
    }

    public final String agentRuntimeName() {
        return this.agentRuntimeName;
    }

    public final String description() {
        return this.description;
    }

    public final AgentRuntimeArtifact agentRuntimeArtifact() {
        return this.agentRuntimeArtifact;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final ProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public final AuthorizerConfiguration authorizerConfiguration() {
        return this.authorizerConfiguration;
    }

    public final RequestHeaderConfiguration requestHeaderConfiguration() {
        return this.requestHeaderConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestHeaderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRuntimeRequest)) {
            return false;
        }
        CreateAgentRuntimeRequest other = (CreateAgentRuntimeRequest)((Object)obj);
        return Objects.equals(this.agentRuntimeName(), other.agentRuntimeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.agentRuntimeArtifact(), other.agentRuntimeArtifact()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.protocolConfiguration(), other.protocolConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.authorizerConfiguration(), other.authorizerConfiguration()) && Objects.equals(this.requestHeaderConfiguration(), other.requestHeaderConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAgentRuntimeRequest").add("AgentRuntimeName", (Object)this.agentRuntimeName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("AgentRuntimeArtifact", (Object)this.agentRuntimeArtifact()).add("RoleArn", (Object)this.roleArn()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("ProtocolConfiguration", (Object)this.protocolConfiguration()).add("ClientToken", (Object)this.clientToken()).add("EnvironmentVariables", (Object)(this.environmentVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthorizerConfiguration", (Object)this.authorizerConfiguration()).add("RequestHeaderConfiguration", (Object)this.requestHeaderConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentRuntimeName": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "agentRuntimeArtifact": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArtifact()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "protocolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.protocolConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "authorizerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfiguration()));
            }
            case "requestHeaderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.requestHeaderConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentRuntimeName", AGENT_RUNTIME_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("agentRuntimeArtifact", AGENT_RUNTIME_ARTIFACT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        map.put("requestHeaderConfiguration", REQUEST_HEADER_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRuntimeRequest, T> g) {
        return obj -> g.apply((CreateAgentRuntimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String agentRuntimeName;
        private String description;
        private AgentRuntimeArtifact agentRuntimeArtifact;
        private String roleArn;
        private NetworkConfiguration networkConfiguration;
        private ProtocolConfiguration protocolConfiguration;
        private String clientToken;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private AuthorizerConfiguration authorizerConfiguration;
        private RequestHeaderConfiguration requestHeaderConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRuntimeRequest model) {
            super(model);
            this.agentRuntimeName(model.agentRuntimeName);
            this.description(model.description);
            this.agentRuntimeArtifact(model.agentRuntimeArtifact);
            this.roleArn(model.roleArn);
            this.networkConfiguration(model.networkConfiguration);
            this.protocolConfiguration(model.protocolConfiguration);
            this.clientToken(model.clientToken);
            this.environmentVariables(model.environmentVariables);
            this.authorizerConfiguration(model.authorizerConfiguration);
            this.requestHeaderConfiguration(model.requestHeaderConfiguration);
            this.tags(model.tags);
        }

        public final String getAgentRuntimeName() {
            return this.agentRuntimeName;
        }

        public final void setAgentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
        }

        @Override
        public final Builder agentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AgentRuntimeArtifact.Builder getAgentRuntimeArtifact() {
            return this.agentRuntimeArtifact != null ? this.agentRuntimeArtifact.toBuilder() : null;
        }

        public final void setAgentRuntimeArtifact(AgentRuntimeArtifact.BuilderImpl agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact != null ? agentRuntimeArtifact.build() : null;
        }

        @Override
        public final Builder agentRuntimeArtifact(AgentRuntimeArtifact agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final ProtocolConfiguration.Builder getProtocolConfiguration() {
            return this.protocolConfiguration != null ? this.protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(ProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(ProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return this.authorizerConfiguration != null ? this.authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        public final RequestHeaderConfiguration.Builder getRequestHeaderConfiguration() {
            return this.requestHeaderConfiguration != null ? this.requestHeaderConfiguration.toBuilder() : null;
        }

        public final void setRequestHeaderConfiguration(RequestHeaderConfiguration.BuilderImpl requestHeaderConfiguration) {
            this.requestHeaderConfiguration = requestHeaderConfiguration != null ? requestHeaderConfiguration.build() : null;
        }

        @Override
        public final Builder requestHeaderConfiguration(RequestHeaderConfiguration requestHeaderConfiguration) {
            this.requestHeaderConfiguration = requestHeaderConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgentRuntimeRequest build() {
            return new CreateAgentRuntimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAgentRuntimeRequest> {
        public Builder agentRuntimeName(String var1);

        public Builder description(String var1);

        public Builder agentRuntimeArtifact(AgentRuntimeArtifact var1);

        default public Builder agentRuntimeArtifact(Consumer<AgentRuntimeArtifact.Builder> agentRuntimeArtifact) {
            return this.agentRuntimeArtifact((AgentRuntimeArtifact)((AgentRuntimeArtifact.Builder)AgentRuntimeArtifact.builder().applyMutation(agentRuntimeArtifact)).build());
        }

        public Builder roleArn(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder protocolConfiguration(ProtocolConfiguration var1);

        default public Builder protocolConfiguration(Consumer<ProtocolConfiguration.Builder> protocolConfiguration) {
            return this.protocolConfiguration((ProtocolConfiguration)((ProtocolConfiguration.Builder)ProtocolConfiguration.builder().applyMutation(protocolConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder authorizerConfiguration(AuthorizerConfiguration var1);

        default public Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return this.authorizerConfiguration((AuthorizerConfiguration)((AuthorizerConfiguration.Builder)AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration)).build());
        }

        public Builder requestHeaderConfiguration(RequestHeaderConfiguration var1);

        default public Builder requestHeaderConfiguration(Consumer<RequestHeaderConfiguration.Builder> requestHeaderConfiguration) {
            return this.requestHeaderConfiguration((RequestHeaderConfiguration)((RequestHeaderConfiguration.Builder)RequestHeaderConfiguration.builder().applyMutation(requestHeaderConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

