/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OAuthCustomParametersCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OAuthScopesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuthCredentialProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuthCredentialProvider> {
    private static final SdkField<String> PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerArn").getter(OAuthCredentialProvider.getter(OAuthCredentialProvider::providerArn)).setter(OAuthCredentialProvider.setter(Builder::providerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerArn").build()}).build();
    private static final SdkField<List<String>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scopes").getter(OAuthCredentialProvider.getter(OAuthCredentialProvider::scopes)).setter(OAuthCredentialProvider.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("customParameters").getter(OAuthCredentialProvider.getter(OAuthCredentialProvider::customParameters)).setter(OAuthCredentialProvider.setter(Builder::customParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_ARN_FIELD, SCOPES_FIELD, CUSTOM_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuthCredentialProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String providerArn;
    private final List<String> scopes;
    private final Map<String, String> customParameters;

    private OAuthCredentialProvider(BuilderImpl builder) {
        this.providerArn = builder.providerArn;
        this.scopes = builder.scopes;
        this.customParameters = builder.customParameters;
    }

    public final String providerArn() {
        return this.providerArn;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public final List<String> scopes() {
        return this.scopes;
    }

    public final boolean hasCustomParameters() {
        return this.customParameters != null && !(this.customParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customParameters() {
        return this.customParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomParameters() ? this.customParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthCredentialProvider)) {
            return false;
        }
        OAuthCredentialProvider other = (OAuthCredentialProvider)obj;
        return Objects.equals(this.providerArn(), other.providerArn()) && this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes()) && this.hasCustomParameters() == other.hasCustomParameters() && Objects.equals(this.customParameters(), other.customParameters());
    }

    public final String toString() {
        return ToString.builder((String)"OAuthCredentialProvider").add("ProviderArn", (Object)this.providerArn()).add("Scopes", this.hasScopes() ? this.scopes() : null).add("CustomParameters", (Object)(this.customParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "providerArn": {
                return Optional.ofNullable(clazz.cast(this.providerArn()));
            }
            case "scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
            case "customParameters": {
                return Optional.ofNullable(clazz.cast(this.customParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("providerArn", PROVIDER_ARN_FIELD);
        map.put("scopes", SCOPES_FIELD);
        map.put("customParameters", CUSTOM_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuthCredentialProvider, T> g) {
        return obj -> g.apply((OAuthCredentialProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerArn;
        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> customParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OAuthCredentialProvider model) {
            this.providerArn(model.providerArn);
            this.scopes(model.scopes);
            this.customParameters(model.customParameters);
        }

        public final String getProviderArn() {
            return this.providerArn;
        }

        public final void setProviderArn(String providerArn) {
            this.providerArn = providerArn;
        }

        @Override
        public final Builder providerArn(String providerArn) {
            this.providerArn = providerArn;
            return this;
        }

        public final Collection<String> getScopes() {
            if (this.scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scopes;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = OAuthScopesCopier.copy(scopes);
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = OAuthScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        public final Map<String, String> getCustomParameters() {
            if (this.customParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customParameters;
        }

        public final void setCustomParameters(Map<String, String> customParameters) {
            this.customParameters = OAuthCustomParametersCopier.copy(customParameters);
        }

        @Override
        public final Builder customParameters(Map<String, String> customParameters) {
            this.customParameters = OAuthCustomParametersCopier.copy(customParameters);
            return this;
        }

        public OAuthCredentialProvider build() {
            return new OAuthCredentialProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuthCredentialProvider> {
        public Builder providerArn(String var1);

        public Builder scopes(Collection<String> var1);

        public Builder scopes(String ... var1);

        public Builder customParameters(Map<String, String> var1);
    }
}

