/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CustomConfigurationInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NamespacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomMemoryStrategyInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomMemoryStrategyInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CustomMemoryStrategyInput.getter(CustomMemoryStrategyInput::name)).setter(CustomMemoryStrategyInput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CustomMemoryStrategyInput.getter(CustomMemoryStrategyInput::description)).setter(CustomMemoryStrategyInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespaces").getter(CustomMemoryStrategyInput.getter(CustomMemoryStrategyInput::namespaces)).setter(CustomMemoryStrategyInput.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomConfigurationInput> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CustomMemoryStrategyInput.getter(CustomMemoryStrategyInput::configuration)).setter(CustomMemoryStrategyInput.setter(Builder::configuration)).constructor(CustomConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, NAMESPACES_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomMemoryStrategyInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<String> namespaces;
    private final CustomConfigurationInput configuration;

    private CustomMemoryStrategyInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.namespaces = builder.namespaces;
        this.configuration = builder.configuration;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public final List<String> namespaces() {
        return this.namespaces;
    }

    public final CustomConfigurationInput configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespaces() ? this.namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomMemoryStrategyInput)) {
            return false;
        }
        CustomMemoryStrategyInput other = (CustomMemoryStrategyInput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasNamespaces() == other.hasNamespaces() && Objects.equals(this.namespaces(), other.namespaces()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"CustomMemoryStrategyInput").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Namespaces", this.hasNamespaces() ? this.namespaces() : null).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomMemoryStrategyInput, T> g) {
        return obj -> g.apply((CustomMemoryStrategyInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();
        private CustomConfigurationInput configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomMemoryStrategyInput model) {
            this.name(model.name);
            this.description(model.description);
            this.namespaces(model.namespaces);
            this.configuration(model.configuration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (this.namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final CustomConfigurationInput.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CustomConfigurationInput.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CustomConfigurationInput configuration) {
            this.configuration = configuration;
            return this;
        }

        public CustomMemoryStrategyInput build() {
            return new CustomMemoryStrategyInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomMemoryStrategyInput> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder namespaces(Collection<String> var1);

        public Builder namespaces(String ... var1);

        public Builder configuration(CustomConfigurationInput var1);

        default public Builder configuration(Consumer<CustomConfigurationInput.Builder> configuration) {
            return this.configuration((CustomConfigurationInput)((CustomConfigurationInput.Builder)CustomConfigurationInput.builder().applyMutation(configuration)).build());
        }
    }
}

