/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentEndpoint;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse;

public class ListAgentRuntimeEndpointsPublisher
implements SdkPublisher<ListAgentRuntimeEndpointsResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListAgentRuntimeEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentRuntimeEndpointsPublisher(BedrockAgentCoreControlAsyncClient client, ListAgentRuntimeEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentRuntimeEndpointsPublisher(BedrockAgentCoreControlAsyncClient client, ListAgentRuntimeEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentRuntimeEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentRuntimeEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AgentEndpoint> runtimeEndpoints() {
        Function<ListAgentRuntimeEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.runtimeEndpoints() != null) {
                return response.runtimeEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentRuntimeEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentRuntimeEndpointsResponseFetcher
    implements AsyncPageFetcher<ListAgentRuntimeEndpointsResponse> {
        private ListAgentRuntimeEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentRuntimeEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentRuntimeEndpointsResponse> nextPage(ListAgentRuntimeEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentRuntimeEndpointsPublisher.this.client.listAgentRuntimeEndpoints(ListAgentRuntimeEndpointsPublisher.this.firstRequest);
            }
            return ListAgentRuntimeEndpointsPublisher.this.client.listAgentRuntimeEndpoints((ListAgentRuntimeEndpointsRequest)((Object)ListAgentRuntimeEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

