/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiKeyCredentialLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiKeyCredentialProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiKeyCredentialProvider> {
    private static final SdkField<String> PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerArn").getter(ApiKeyCredentialProvider.getter(ApiKeyCredentialProvider::providerArn)).setter(ApiKeyCredentialProvider.setter(Builder::providerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerArn").build()}).build();
    private static final SdkField<String> CREDENTIAL_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialParameterName").getter(ApiKeyCredentialProvider.getter(ApiKeyCredentialProvider::credentialParameterName)).setter(ApiKeyCredentialProvider.setter(Builder::credentialParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialParameterName").build()}).build();
    private static final SdkField<String> CREDENTIAL_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialPrefix").getter(ApiKeyCredentialProvider.getter(ApiKeyCredentialProvider::credentialPrefix)).setter(ApiKeyCredentialProvider.setter(Builder::credentialPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialPrefix").build()}).build();
    private static final SdkField<String> CREDENTIAL_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialLocation").getter(ApiKeyCredentialProvider.getter(ApiKeyCredentialProvider::credentialLocationAsString)).setter(ApiKeyCredentialProvider.setter(Builder::credentialLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_ARN_FIELD, CREDENTIAL_PARAMETER_NAME_FIELD, CREDENTIAL_PREFIX_FIELD, CREDENTIAL_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiKeyCredentialProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String providerArn;
    private final String credentialParameterName;
    private final String credentialPrefix;
    private final String credentialLocation;

    private ApiKeyCredentialProvider(BuilderImpl builder) {
        this.providerArn = builder.providerArn;
        this.credentialParameterName = builder.credentialParameterName;
        this.credentialPrefix = builder.credentialPrefix;
        this.credentialLocation = builder.credentialLocation;
    }

    public final String providerArn() {
        return this.providerArn;
    }

    public final String credentialParameterName() {
        return this.credentialParameterName;
    }

    public final String credentialPrefix() {
        return this.credentialPrefix;
    }

    public final ApiKeyCredentialLocation credentialLocation() {
        return ApiKeyCredentialLocation.fromValue(this.credentialLocation);
    }

    public final String credentialLocationAsString() {
        return this.credentialLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialLocationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiKeyCredentialProvider)) {
            return false;
        }
        ApiKeyCredentialProvider other = (ApiKeyCredentialProvider)obj;
        return Objects.equals(this.providerArn(), other.providerArn()) && Objects.equals(this.credentialParameterName(), other.credentialParameterName()) && Objects.equals(this.credentialPrefix(), other.credentialPrefix()) && Objects.equals(this.credentialLocationAsString(), other.credentialLocationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApiKeyCredentialProvider").add("ProviderArn", (Object)this.providerArn()).add("CredentialParameterName", (Object)this.credentialParameterName()).add("CredentialPrefix", (Object)this.credentialPrefix()).add("CredentialLocation", (Object)this.credentialLocationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "providerArn": {
                return Optional.ofNullable(clazz.cast(this.providerArn()));
            }
            case "credentialParameterName": {
                return Optional.ofNullable(clazz.cast(this.credentialParameterName()));
            }
            case "credentialPrefix": {
                return Optional.ofNullable(clazz.cast(this.credentialPrefix()));
            }
            case "credentialLocation": {
                return Optional.ofNullable(clazz.cast(this.credentialLocationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("providerArn", PROVIDER_ARN_FIELD);
        map.put("credentialParameterName", CREDENTIAL_PARAMETER_NAME_FIELD);
        map.put("credentialPrefix", CREDENTIAL_PREFIX_FIELD);
        map.put("credentialLocation", CREDENTIAL_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiKeyCredentialProvider, T> g) {
        return obj -> g.apply((ApiKeyCredentialProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerArn;
        private String credentialParameterName;
        private String credentialPrefix;
        private String credentialLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiKeyCredentialProvider model) {
            this.providerArn(model.providerArn);
            this.credentialParameterName(model.credentialParameterName);
            this.credentialPrefix(model.credentialPrefix);
            this.credentialLocation(model.credentialLocation);
        }

        public final String getProviderArn() {
            return this.providerArn;
        }

        public final void setProviderArn(String providerArn) {
            this.providerArn = providerArn;
        }

        @Override
        public final Builder providerArn(String providerArn) {
            this.providerArn = providerArn;
            return this;
        }

        public final String getCredentialParameterName() {
            return this.credentialParameterName;
        }

        public final void setCredentialParameterName(String credentialParameterName) {
            this.credentialParameterName = credentialParameterName;
        }

        @Override
        public final Builder credentialParameterName(String credentialParameterName) {
            this.credentialParameterName = credentialParameterName;
            return this;
        }

        public final String getCredentialPrefix() {
            return this.credentialPrefix;
        }

        public final void setCredentialPrefix(String credentialPrefix) {
            this.credentialPrefix = credentialPrefix;
        }

        @Override
        public final Builder credentialPrefix(String credentialPrefix) {
            this.credentialPrefix = credentialPrefix;
            return this;
        }

        public final String getCredentialLocation() {
            return this.credentialLocation;
        }

        public final void setCredentialLocation(String credentialLocation) {
            this.credentialLocation = credentialLocation;
        }

        @Override
        public final Builder credentialLocation(String credentialLocation) {
            this.credentialLocation = credentialLocation;
            return this;
        }

        @Override
        public final Builder credentialLocation(ApiKeyCredentialLocation credentialLocation) {
            this.credentialLocation(credentialLocation == null ? null : credentialLocation.toString());
            return this;
        }

        public ApiKeyCredentialProvider build() {
            return new ApiKeyCredentialProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiKeyCredentialProvider> {
        public Builder providerArn(String var1);

        public Builder credentialParameterName(String var1);

        public Builder credentialPrefix(String var1);

        public Builder credentialLocation(String var1);

        public Builder credentialLocation(ApiKeyCredentialLocation var1);
    }
}

