/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a workload identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadIdentityType implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadIdentityType.Builder, WorkloadIdentityType> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WorkloadIdentityType::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> WORKLOAD_IDENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadIdentityArn").getter(getter(WorkloadIdentityType::workloadIdentityArn))
            .setter(setter(Builder::workloadIdentityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            WORKLOAD_IDENTITY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String workloadIdentityArn;

    private WorkloadIdentityType(BuilderImpl builder) {
        this.name = builder.name;
        this.workloadIdentityArn = builder.workloadIdentityArn;
    }

    /**
     * <p>
     * The name of the workload identity.
     * </p>
     * 
     * @return The name of the workload identity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workload identity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workload identity.
     */
    public final String workloadIdentityArn() {
        return workloadIdentityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(workloadIdentityArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadIdentityType)) {
            return false;
        }
        WorkloadIdentityType other = (WorkloadIdentityType) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(workloadIdentityArn(), other.workloadIdentityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadIdentityType").add("Name", name()).add("WorkloadIdentityArn", workloadIdentityArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "workloadIdentityArn":
            return Optional.ofNullable(clazz.cast(workloadIdentityArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("workloadIdentityArn", WORKLOAD_IDENTITY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadIdentityType, T> g) {
        return obj -> g.apply((WorkloadIdentityType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadIdentityType> {
        /**
         * <p>
         * The name of the workload identity.
         * </p>
         * 
         * @param name
         *        The name of the workload identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workload identity.
         * </p>
         * 
         * @param workloadIdentityArn
         *        The Amazon Resource Name (ARN) of the workload identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadIdentityArn(String workloadIdentityArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String workloadIdentityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadIdentityType model) {
            name(model.name);
            workloadIdentityArn(model.workloadIdentityArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkloadIdentityArn() {
            return workloadIdentityArn;
        }

        public final void setWorkloadIdentityArn(String workloadIdentityArn) {
            this.workloadIdentityArn = workloadIdentityArn;
        }

        @Override
        public final Builder workloadIdentityArn(String workloadIdentityArn) {
            this.workloadIdentityArn = workloadIdentityArn;
            return this;
        }

        @Override
        public WorkloadIdentityType build() {
            return new WorkloadIdentityType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
